/*
 * Decompiled with CFR 0.152.
 */
package com.ksc.mission.base.http;

import com.ksc.mission.base.http.HttpConnectorSpec;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLConnection;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;

public class HttpStreamingOutput
implements StreamingOutput {
    public static final int BUF_SIZE = 0x1000000;
    protected final URLConnection connection;
    public final long contentLength;

    public HttpStreamingOutput(HttpConnectorSpec spec, String path) throws Exception {
        this.connection = spec.target.path(path).getUri().toURL().openConnection();
        this.contentLength = this.connection.getContentLengthLong();
    }

    public void write(OutputStream os) throws IOException, WebApplicationException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(this.connection.getInputStream());
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(os);
        byte[] bytes = new byte[0x1000000];
        int count = 0;
        while ((count = bufferedInputStream.read(bytes)) != -1) {
            bufferedOutputStream.write(bytes, 0, count);
        }
        bufferedInputStream.close();
        bufferedOutputStream.flush();
    }
}

