/*
 * Decompiled with CFR 0.152.
 */
package com.ksc.mission.base.interfaces;

import com.ksc.mission.base.interfaces.IMessage;
import com.ksc.mission.base.interfaces.IMessageHub;
import com.ksc.mission.base.interfaces.ISend;
import com.ksc.mission.base.interfaces.ListenRequest;
import java.util.function.Consumer;

public interface IFollow {
    public IMessageHub getMessageHub();

    public String getId();

    default public void subscribe(ISend publisher, Consumer<IMessage> action) {
        this.getMessageHub().subscribePublisher(new ListenRequest<IMessage>(this, publisher, action));
    }

    default public void subscribe(String hashtag, Consumer<IMessage> action) {
        this.getMessageHub().subscribeHashtag(new ListenRequest<IMessage>(this, hashtag, action));
    }

    default public void unsubscribe(ISend publisher) {
        this.getMessageHub().unsubscribePublisher(new ListenRequest<IMessage>(this, publisher, null));
    }

    default public void unsubscribe(String hashtag) {
        this.getMessageHub().unsubscribeHashtag(new ListenRequest<IMessage>(this, hashtag, null));
    }

    default public void listen(ISend publisher, Consumer<IMessage> action) {
        this.getMessageHub().listenPublisher(new ListenRequest<IMessage>(this, publisher, action));
    }

    default public void listen(String hashtag, Consumer<IMessage> action) {
        this.getMessageHub().listenHashtag(new ListenRequest<IMessage>(this, hashtag, action));
    }

    default public void stopListening(ISend publisher) {
        this.getMessageHub().stopListeningPublisher(new ListenRequest<IMessage>(this, publisher, null));
    }

    default public void stopListening(String hashtag) {
        this.getMessageHub().stopListeningHashtag(new ListenRequest<IMessage>(this, hashtag, null));
    }
}

