/*
 * Decompiled with CFR 0.152.
 */
package com.ksc.mission.base.interfaces;

import com.ksc.mission.base.interfaces.IMessage;
import com.ksc.mission.base.interfaces.ISend;
import com.ksc.mission.base.interfaces.ListenRequest;
import com.ksc.mission.base.interfaces.Message;
import java.io.Serializable;

public interface IMessageHub {
    public IMessage publish(IMessage var1);

    public IMessage send(IMessage var1);

    default public void start() {
    }

    default public IMessage send(ISend publisher, String hashtag, Serializable payload) {
        return this.send(new Message("Publish", hashtag, publisher, payload));
    }

    default public IMessage publish(ISend publisher, String hashtag, Serializable payload) {
        return this.publish(new Message("Publish", hashtag, publisher, payload));
    }

    default public void subscribe(ListenRequest<IMessage> listenRequest) {
        if (listenRequest.getHashtag() != null) {
            this.subscribeHashtag(listenRequest);
        } else {
            this.subscribePublisher(listenRequest);
        }
    }

    default public void unsubscribe(ListenRequest<IMessage> listenRequest) {
        if (listenRequest.getHashtag() != null) {
            this.unsubscribeHashtag(listenRequest);
        } else {
            this.unsubscribePublisher(listenRequest);
        }
    }

    default public void listen(ListenRequest<IMessage> listenRequest) {
        if (listenRequest.getHashtag() != null) {
            this.listenHashtag(listenRequest);
        } else {
            this.listenPublisher(listenRequest);
        }
    }

    default public void stopListening(ListenRequest<IMessage> listenRequest) {
        if (listenRequest.getHashtag() != null) {
            this.stopListeningHashtag(listenRequest);
        } else {
            this.stopListeningPublisher(listenRequest);
        }
    }

    public void subscribeHashtag(ListenRequest<IMessage> var1);

    public void subscribePublisher(ListenRequest<IMessage> var1);

    public void unsubscribeHashtag(ListenRequest<IMessage> var1);

    public void unsubscribePublisher(ListenRequest<IMessage> var1);

    public void listenHashtag(ListenRequest<IMessage> var1);

    public void listenPublisher(ListenRequest<IMessage> var1);

    public void stopListeningHashtag(ListenRequest<IMessage> var1);

    public void stopListeningPublisher(ListenRequest<IMessage> var1);
}

