/*
 * Decompiled with CFR 0.152.
 */
package com.ksc.mission.base.interfaces;

import com.ksc.mission.base.interfaces.IMessageHub;
import com.ksc.mission.base.interfaces.IOwner;
import com.ksc.mission.base.interfaces.ISave;
import com.ksc.mission.base.interfaces.Initializable;
import java.io.Serializable;

public interface IOwned<TYPE extends IOwned<TYPE, OWNER>, OWNER extends IOwned<OWNER, ?>>
extends IOwner,
ISave,
Serializable,
Initializable<TYPE> {
    public static final long serialVersionUID = 1L;

    @Override
    public String getId();

    public void setId(String var1);

    public String toString();

    public String getDescription();

    public boolean hasBeenSaved();

    public IOwned<?, ?> getHighestUnsavedOwner();

    @Override
    public boolean exists();

    public OWNER getOwner();

    @Override
    default public IMessageHub getMessageHub() {
        return this.getOwner().getMessageHub();
    }

    default public String getLocatorPath() {
        if (this.getOwner() == null) {
            return this.getClass().getSimpleName() + "/" + this.getId();
        }
        return this.getOwner().getLocatorPath() + "/" + this.getId();
    }

    @Override
    default public void save() {
        this.publish("#CREATED_UPDATED", this);
    }

    default public void delete() {
        this.publish("#DELETED", this);
    }
}

