/*
 * Decompiled with CFR 0.152.
 */
package com.ksc.mission.base.interfaces;

import com.ksc.mission.base.interfaces.IMessage;
import com.ksc.mission.base.interfaces.ISend;
import java.io.Serializable;
import java.util.UUID;
import java.util.function.Consumer;

public class Message
implements IMessage {
    private static final long serialVersionUID = 1L;
    public static final String SEND = "Send";
    public static final String PUBLISH = "Publish";
    public final String id;
    public final String publisherId;
    public final String hashtag;
    public final String type;
    public final Serializable payload;
    public Serializable response;
    public Consumer<Object> then;
    public Consumer<Object> onError;
    public Consumer<Exception> onException;

    public Message(String hashtag, Serializable payload) {
        this(SEND, hashtag, null, payload, null);
    }

    public Message(String type, String hashtag, ISend publisher, Serializable payload) {
        this(type, hashtag, publisher.getPublisherId(), payload, null);
    }

    public Message(IMessage message, Serializable response) {
        this(message.getId(), message.getHashtag(), message.getPublisherId(), message.getPayload(), response);
    }

    public Message(String type, String hashtag, String publisherId, Serializable payload, Serializable response) {
        this.id = UUID.randomUUID().toString();
        this.type = type;
        this.hashtag = hashtag;
        this.publisherId = publisherId;
        this.payload = payload;
        this.response = response;
    }

    public Message(String id, String type, String hashtag, String publisherId, Serializable payload, Serializable response) {
        this.id = id;
        this.type = type;
        this.hashtag = hashtag;
        this.publisherId = publisherId;
        this.payload = payload;
        this.response = response;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getPublisherId() {
        return this.publisherId;
    }

    @Override
    public Serializable getPayload() {
        return this.payload;
    }

    @Override
    public String getHashtag() {
        return this.hashtag;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(Tag:" + this.hashtag + ", Sender:" + this.publisherId + ", Payload:" + this.payload + ")";
    }

    @Override
    public void setResponse(Serializable response) {
        this.response = response;
    }

    @Override
    public Serializable getResponse() {
        return this.response;
    }

    @Override
    public void respondWith(Serializable response) {
        this.setResponse(response);
        if (this.then != null) {
            this.then.accept(response);
        }
    }

    @Override
    public void respondWithErrorResponse(Serializable response) {
        this.setResponse(response);
        if (this.onError != null) {
            this.onError.accept(response);
        }
    }

    @Override
    public void respondWith(Exception response) {
        this.setResponse(response);
        if (this.onException != null) {
            this.onException.accept(response);
        }
    }

    @Override
    public IMessage then(Consumer<Object> action) {
        this.then = action;
        return this;
    }

    @Override
    public IMessage onError(Consumer<Object> action) {
        this.onError = action;
        return this;
    }

    @Override
    public IMessage onException(Consumer<Exception> action) {
        this.onException = action;
        return this;
    }

    @Override
    public String getType() {
        return this.type;
    }
}

