/*
 * Decompiled with CFR 0.152.
 */
package com.ksc.mission.base.interfaces;

import com.ksc.mission.base.interfaces.ILog;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.function.Supplier;

public abstract class ObjectHandler<TYPE>
implements InvocationHandler,
ILog {
    private static final long serialVersionUID = 1L;
    protected final String jarName;
    protected final Supplier<TYPE> creator;
    protected ClassLoader classLoader;
    protected TYPE target;

    public ObjectHandler(String jarName, Supplier<TYPE> creator, ClassLoader classLoader) {
        this.jarName = jarName;
        this.creator = creator;
        this.classLoader = classLoader;
    }

    public TYPE newProxy() {
        return (TYPE)this.doWithClassLoader(() -> Proxy.newProxyInstance(this.classLoader, null, (InvocationHandler)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doWithClassLoader(Supplier<Object> block) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            Object object = block.get();
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        Object result = null;
        try {
            result = method.invoke(this.target, args);
        }
        catch (Exception e) {
            this.logError("Error - ", e);
        }
        return result;
    }
}

