/*
 * Decompiled with CFR 0.152.
 */
package com.ksc.mission.base.interfaces;

import java.io.InputStream;
import java.util.Properties;

public class PropertiesReader {
    public static Properties from(String environmentName, String name) {
        try {
            Properties appProps = new Properties();
            InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("properties/default-" + name + ".properties");
            if (stream == null) {
                stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("resources/properties/default-" + name + ".properties");
            }
            appProps.load(stream);
            if (environmentName != null) {
                try {
                    stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("properties/" + environmentName + "-" + name + ".properties");
                    if (stream == null) {
                        stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("resources/properties/" + environmentName + "-" + name + ".properties");
                    }
                    if (stream == null) {
                        System.out.println("File not found - properties/" + environmentName + "-s3.properties");
                    } else {
                        appProps.load(stream);
                    }
                }
                catch (Exception ex) {
                    System.out.println("PropertiesReader - " + name + " - Failed to read properties for environment - " + environmentName + " - " + ex.getMessage());
                }
            }
            return appProps;
        }
        catch (Exception ex) {
            System.out.println("PropertiesReader - " + name + " - Failed to read properties - " + ex.getMessage());
            return null;
        }
    }
}

