/*
 * Decompiled with CFR 0.152.
 */
package com.ksc.mission.base.relatedobjects;

import com.ksc.mission.base.fileutils.FileUtil;
import com.ksc.mission.base.interfaces.ExFunction;
import com.ksc.mission.base.interfaces.ExSupplier;
import com.ksc.mission.base.interfaces.ICreate;
import com.ksc.mission.base.interfaces.ILog;
import com.ksc.mission.base.interfaces.IMessageHub;
import com.ksc.mission.base.interfaces.IOwned;
import com.ksc.mission.base.interfaces.IOwnedCollection;
import com.ksc.mission.base.interfaces.IOwnedN;
import com.ksc.mission.base.interfaces.IRoot;
import com.ksc.mission.base.interfaces.ISend;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;

public class OwnedHashMap<KEY, TYPE extends IOwnedN<TYPE, OWNER>, OWNER extends IOwned<OWNER, ?>>
extends HashMap<KEY, TYPE>
implements IOwnedCollection<TYPE, OWNER>,
ICreate<TYPE>,
ISend,
ILog,
Serializable {
    private static final long serialVersionUID = 1L;
    private static long maxId = 100000L;
    protected transient ExFunction<TYPE, KEY> keyAccessor;
    protected String id;
    transient ExSupplier<TYPE> creator;
    transient OWNER owner;

    protected synchronized String _nextId() {
        return (this.getClass().getSimpleName() + "-" + maxId++).intern();
    }

    public String getPublisherId() {
        return this.getId();
    }

    public String getId() {
        if (this.id == null) {
            this.id = this._nextId();
        }
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    protected IRoot getRoot() {
        return this.getOwner().getRoot();
    }

    public void initializeFromFilePath(String filePath) {
        new FileUtil("").readAll((ICreate)this, filePath);
    }

    public void initializeFromLinesUpTo(Iterator<String[]> iterator, String tag) {
        new FileUtil("").doWithIterator(iterator, lineIterator -> ((IOwnedN)this.create().initializeFromStrings(lineIterator)).save(), lineIterator -> ((String)lineIterator.next()).equalsIgnoreCase(tag));
    }

    public void initializeFromObjects(Iterator<Object[]> rowsIterator) {
        Consumer<Object[]> doForEach = objects -> ((IOwnedN)this.create().initializeFromObjects(objects)).save();
        Object[] objects2 = null;
        try {
            while (rowsIterator.hasNext() && (objects2 = rowsIterator.next()) != null) {
                doForEach.accept(objects2);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public OwnedHashMap(Class<TYPE> type, OWNER owner) {
        this.keyAccessor = object -> object.getId();
        this.creator = () -> (IOwnedN)type.newInstance();
        this.owner = owner;
    }

    public OwnedHashMap(ExSupplier<TYPE> creator, OWNER owner) {
        this.keyAccessor = object -> object.getId();
        this.creator = creator;
        this.owner = owner;
    }

    public OwnedHashMap(ExFunction<TYPE, KEY> keyAccessor, ExSupplier<TYPE> creator, OWNER owner) {
        this.keyAccessor = keyAccessor;
        this.creator = creator;
        this.owner = owner;
    }

    public OwnedHashMap(OWNER owner) {
        this.owner = owner;
    }

    public TYPE create() {
        IOwnedN newInst = null;
        try {
            if (this.creator == null) {
                return null;
            }
            newInst = (IOwnedN)this.creator.get();
        }
        catch (Exception e) {
            this.publish("#Error", e);
        }
        newInst.setOwningCollection((IOwnedCollection)this);
        return (TYPE)newInst;
    }

    public void save(TYPE obj) {
        try {
            this.put(this.getKey(obj), obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void basicPut(KEY key, TYPE obj) {
        if (!this.contains(obj)) {
            obj.setOwningCollection((IOwnedCollection)this);
            super.put(key, obj);
        }
    }

    @Override
    public TYPE put(KEY key, TYPE obj) {
        try {
            if (!this.contains(obj)) {
                obj.setOwningCollection((IOwnedCollection)this);
                super.put(key, obj);
                this.publish("#CREATED", (Serializable)obj);
            } else {
                this.publish("#UPDATED", (Serializable)obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return obj;
    }

    private KEY getKey(TYPE obj) throws Exception {
        return (KEY)this.keyAccessor.apply(obj);
    }

    public void delete(TYPE obj) {
        try {
            if (this.contains(obj)) {
                super.remove(this.getKey(obj));
                this.publish("#DELETED", (Serializable)obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveAll(List<TYPE> col) {
        ArrayList<IOwnedN> created = new ArrayList<IOwnedN>();
        ArrayList<IOwnedN> updated = new ArrayList<IOwnedN>();
        for (IOwnedN element : col) {
            if (this.contains(element)) {
                updated.add(element);
                continue;
            }
            created.add(element);
        }
        for (IOwnedN element : created) {
            try {
                this.put(this.getKey(element), (TYPE)element);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.publish("#CREATED", created);
        this.publish("#UPDATED", updated);
    }

    public void deleteAll(List<TYPE> col) {
        ArrayList<IOwnedN> deleted = new ArrayList<IOwnedN>();
        try {
            for (IOwnedN element : col) {
                if (!this.contains(element)) continue;
                deleted.add(element);
                super.remove(this.getKey(element));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.publish("#DELETED", deleted);
    }

    public TYPE atId(String id) {
        TYPE newElement = this.basicAtId(id);
        if (newElement == null) {
            newElement = this.create();
            newElement.setId(id);
        }
        return newElement;
    }

    public TYPE basicAtId(String id) {
        for (IOwnedN element : this.values()) {
            if (!element.getId().equals(id)) continue;
            return (TYPE)element;
        }
        return null;
    }

    public OWNER getOwner() {
        return this.owner;
    }

    public boolean contains(Object ownedObject) {
        try {
            return this.basicAtId(((IOwnedN)ownedObject).getId()) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public IMessageHub getMessageHub() {
        return this.getOwner().getMessageHub();
    }

    public void basicSave(TYPE element) {
        if (!this.contains(element)) {
            try {
                this.basicPut(this.getKey(element), element);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void basicSaveAll(List<TYPE> col) {
        for (IOwnedN element : col) {
            this.basicSave((TYPE)element);
        }
    }
}

