/*
 * Decompiled with CFR 0.152.
 */
package com.ksc.mission.base.relatedobjects;

import com.ksc.mission.base.fileutils.FileUtil;
import com.ksc.mission.base.interfaces.ExSupplier;
import com.ksc.mission.base.interfaces.ICreate;
import com.ksc.mission.base.interfaces.IFollow;
import com.ksc.mission.base.interfaces.ILog;
import com.ksc.mission.base.interfaces.IMessageHub;
import com.ksc.mission.base.interfaces.IOwned;
import com.ksc.mission.base.interfaces.IOwnedCollection;
import com.ksc.mission.base.interfaces.IOwnedN;
import com.ksc.mission.base.interfaces.IRoot;
import com.ksc.mission.base.interfaces.ISend;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;

public class OwnedList<TYPE extends IOwnedN<TYPE, OWNER>, OWNER extends IOwned<OWNER, ?>>
extends ArrayList<TYPE>
implements IOwnedCollection<TYPE, OWNER>,
ICreate<TYPE>,
Serializable,
ISend,
ILog,
IFollow {
    private static final long serialVersionUID = 1L;
    private static long maxId = 100000L;
    protected String id;
    protected transient ExSupplier<TYPE> creator;
    protected transient OWNER owner;

    public OwnedList() {
    }

    protected synchronized String _nextId() {
        return (this.getClass().getSimpleName() + "-" + maxId++).intern();
    }

    public String getPublisherId() {
        return this.getId();
    }

    public String getId() {
        if (this.id == null) {
            this.id = this._nextId();
        }
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    protected IRoot getRoot() {
        return this.getOwner().getRoot();
    }

    public void initializeFromFilePath(String filePath) {
        new FileUtil("").readAll((ICreate)this, filePath);
    }

    public void initializeFromLinesUpTo(Iterator<String[]> iterator, String tag) {
        new FileUtil("").doWithIterator(iterator, lineIterator -> ((IOwnedN)this.create().initializeFromStrings(lineIterator)).save(), lineIterator -> ((String)lineIterator.next()).equalsIgnoreCase(tag));
    }

    public void initializeFromObjects(Iterator<Object[]> rowsIterator) {
        Consumer<Object[]> doForEach = objects -> ((IOwnedN)this.create().initializeFromObjects(objects)).save();
        Object[] objects2 = null;
        try {
            while (rowsIterator.hasNext() && (objects2 = rowsIterator.next()) != null) {
                doForEach.accept(objects2);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public OwnedList(Class<TYPE> type, OWNER owner) {
        this.creator = () -> (IOwnedN)type.newInstance();
        this.owner = owner;
    }

    public OwnedList(ExSupplier<TYPE> creator, OWNER owner) {
        this.creator = creator;
        this.owner = owner;
    }

    public TYPE create() {
        IOwnedN newInst = null;
        try {
            newInst = (IOwnedN)this.creator.get();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        newInst.setOwningCollection((IOwnedCollection)this);
        return (TYPE)newInst;
    }

    public void save(TYPE obj) {
        if (!this.contains(obj)) {
            obj.setOwningCollection((IOwnedCollection)this);
            this.add(obj);
            this.publish("#CREATED", (Serializable)obj);
        } else {
            this.publish("#UPDATED", (Serializable)obj);
        }
    }

    public void delete(TYPE obj) {
        if (this.contains(obj)) {
            super.remove(obj);
            this.publish("#DELETED", (Serializable)obj);
        }
    }

    public void saveAll(List<TYPE> col) {
        ArrayList<IOwnedN> created = new ArrayList<IOwnedN>();
        ArrayList<IOwnedN> updated = new ArrayList<IOwnedN>();
        for (IOwnedN element : col) {
            if (this.contains(element)) {
                updated.add(element);
                continue;
            }
            element.setOwningCollection((IOwnedCollection)this);
            created.add(element);
        }
        super.addAll(created);
        this.publish("#CREATED", created);
        this.publish("#UPDATED", updated);
    }

    public void basicSaveAll(List<TYPE> col) {
        for (IOwnedN element : col) {
            this.basicSave((TYPE)element);
        }
    }

    public void basicSave(TYPE element) {
        if (!this.contains(element)) {
            element.setOwningCollection((IOwnedCollection)this);
            super.add(element);
        }
    }

    public void deleteAll(List<TYPE> col) {
        ArrayList<IOwnedN> deleted = new ArrayList<IOwnedN>();
        for (IOwnedN element : col) {
            if (!this.contains(element)) continue;
            deleted.add(element);
        }
        super.removeAll(deleted);
        this.publish("#DELETED", deleted);
    }

    public TYPE atId(String id) {
        TYPE newElement = this.basicAtId(id);
        if (newElement == null) {
            newElement = this.create();
            newElement.setId(id);
        }
        return newElement;
    }

    public TYPE basicAtId(String id) {
        for (IOwnedN element : this) {
            if (!element.getId().equals(id)) continue;
            return (TYPE)element;
        }
        return null;
    }

    public OWNER getOwner() {
        return this.owner;
    }

    @Override
    public boolean contains(Object ownedObject) {
        try {
            return this.basicAtId(((IOwnedN)ownedObject).getId()) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public IMessageHub getMessageHub() {
        return this.getOwner().getMessageHub();
    }
}

