/*
 * Decompiled with CFR 0.152.
 */
package com.ksc.mission.base.relatedobjects;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.ksc.mission.base.interfaces.IOwned;
import com.ksc.mission.base.interfaces.IOwnedCollection;
import com.ksc.mission.base.interfaces.IOwnedN;
import com.ksc.mission.base.interfaces.IRoot;
import com.ksc.mission.base.interfaces.Initializable;
import java.util.Iterator;
import java.util.UUID;

public abstract class OwnedObject<TYPE extends IOwnedN<TYPE, OWNER>, OWNER extends IOwned<OWNER, ?>>
implements IOwnedN<TYPE, OWNER>,
Initializable<TYPE> {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected transient IOwnedCollection<TYPE, OWNER> owningCollection;

    protected String _nextId() {
        return UUID.randomUUID().toString().intern();
    }

    public String getPublisherId() {
        return this.getId();
    }

    public String getId() {
        if (this.id == null) {
            this.id = this._nextId();
        }
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    @JsonIgnore
    public IRoot getRoot() {
        OWNER owner = this.getOwner();
        if (owner != null && owner.isRoot()) {
            return (IRoot)owner;
        }
        return this.getOwner().getRoot();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getDescription() + ")";
    }

    public String getDescription() {
        return this.getId();
    }

    public void save() {
        if (this.getOwningCollection() == null) {
            throw new Error(this + " does not have an owning collection");
        }
        this.getOwningCollection().save((Object)this);
    }

    public boolean hasBeenSaved() {
        return this.getHighestUnsavedOwner() == null;
    }

    @JsonIgnore
    public IOwned<?, ?> getHighestUnsavedOwner() {
        OwnedObject current = this;
        while (current.exists()) {
            if (!(current = current.getOwner()).isRoot()) continue;
            return null;
        }
        return current;
    }

    public boolean isRoot() {
        return false;
    }

    public boolean exists() {
        if (this.getOwningCollection() == null) {
            return this.getOwner() != null;
        }
        return this.getOwningCollection().contains((Object)this);
    }

    public void delete() {
        this.getOwningCollection().delete((Object)this);
    }

    @JsonIgnore
    public OWNER getOwner() {
        if (this.getOwningCollection() == null) {
            return null;
        }
        return (OWNER)this.getOwningCollection().getOwner();
    }

    @JsonIgnore
    public IOwnedCollection<TYPE, OWNER> getOwningCollection() {
        return this.owningCollection;
    }

    public void setOwningCollection(IOwnedCollection<TYPE, OWNER> owningCollection) {
        this.owningCollection = owningCollection;
    }

    public TYPE initializeFromObjects(Object[] objects) {
        return (TYPE)this;
    }

    public TYPE initializeFromStrings(Iterator<String> iterator) {
        return null;
    }
}

