/*
 * Decompiled with CFR 0.152.
 */
package com.ksc.mission.base.relatedobjects;

import com.ksc.mission.base.interfaces.IMessageHub;
import com.ksc.mission.base.interfaces.IOwned;
import com.ksc.mission.base.interfaces.IRoot;
import com.ksc.mission.base.interfaces.Initializable;
import java.io.Serializable;
import java.util.Iterator;

public class OwnedSingleton<TYPE extends IOwned<TYPE, OWNER>, OWNER extends IOwned<OWNER, ?>>
implements IOwned<TYPE, OWNER>,
Initializable<TYPE> {
    private static final long serialVersionUID = 1L;
    private static long maxId = 100000L;
    protected String id;
    protected OWNER owner;

    public OwnedSingleton() {
    }

    public OwnedSingleton(OWNER owner) {
        this.owner = owner;
    }

    protected synchronized String _nextId() {
        return (this.getClass().getSimpleName() + "-" + maxId++).intern();
    }

    public String getPublisherId() {
        return this.getId();
    }

    public String getId() {
        if (this.id == null) {
            this.id = this._nextId();
        }
        return this.id;
    }

    public void setId(String id) {
        this.id = id.intern();
    }

    public IRoot getRoot() {
        OWNER owner = this.getOwner();
        if (owner != null && owner.isRoot()) {
            return (IRoot)owner;
        }
        return this.getOwner().getRoot();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getDescription() + ")";
    }

    public String getDescription() {
        return this.getId();
    }

    public boolean hasBeenSaved() {
        return this.getHighestUnsavedOwner() == null;
    }

    public IOwned<?, ?> getHighestUnsavedOwner() {
        OwnedSingleton current = this;
        while (current.exists()) {
            if (!(current = current.getOwner()).isRoot()) continue;
            return null;
        }
        return current;
    }

    public boolean isRoot() {
        return false;
    }

    public boolean exists() {
        return this.getOwner() != null && this.getOwner().exists();
    }

    public void setOwner(OWNER owner) {
        this.owner = owner;
    }

    public OWNER getOwner() {
        return this.owner;
    }

    public TYPE initializeFromStrings(Iterator<String> iterator) {
        throw new Error("Subclass Responsibility");
    }

    public TYPE initializeFromObjects(Object[] objects) {
        throw new Error("Subclass Responsibility");
    }

    public void save() {
        this.publish("#UPDATED", (Serializable)((Object)this));
    }

    public void delete() {
    }

    public IMessageHub getMessageHub() {
        return this.getOwner().getMessageHub();
    }
}

