/*
 * Decompiled with CFR 0.152.
 */
package com.ksc.mission.base.relatedobjects;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.ksc.mission.base.interfaces.IMessageHub;
import com.ksc.mission.base.interfaces.IOwned;
import com.ksc.mission.base.interfaces.IRoot;
import com.ksc.mission.base.relatedobjects.IOwnedService;
import com.ksc.mission.base.relatedobjects.OwnedHashMap;
import com.ksc.mission.base.relatedobjects.OwnedObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

public class OwningContainer
extends OwnedObject<OwningContainer, OwningContainer>
implements IRoot,
Serializable {
    private static final long serialVersionUID = 1L;
    protected transient IMessageHub messageHub;
    protected final String id = UUID.randomUUID().toString().intern();
    protected final OwnedHashMap<String, IOwnedService, OwningContainer> services = new OwnedHashMap(service -> service.getClass().getSimpleName(), null, this);
    protected final List<IOwnedService> startOrder;
    protected boolean started = false;

    public OwningContainer(IMessageHub messageHub, List<IOwnedService> newServices) {
        this.startOrder = new ArrayList<IOwnedService>(newServices);
        this.messageHub = messageHub;
    }

    @JsonIgnore
    public IMessageHub getMessageHub() {
        return this.messageHub;
    }

    public void start() throws Exception {
        if (!this.started) {
            this.messageHub.start();
            this.saveServices();
            this.startServices();
            this.started = true;
        }
    }

    public void startServices() throws Exception {
        for (IOwnedService service : this.startOrder) {
            service.start();
        }
    }

    public void saveServices() {
        this.startOrder.forEach(service -> this.services.save((IOwnedService)service));
    }

    public void addService(IOwnedService service) throws Exception {
        this.startOrder.add(service);
        if (this.started) {
            this.services.save(service);
            service.start();
        }
    }

    public void addServices(List<IOwnedService> newServices) throws Exception {
        for (IOwnedService service : newServices) {
            this.addService(service);
        }
    }

    @Override
    public String getPublisherId() {
        return this.id;
    }

    @Override
    public boolean isRoot() {
        return true;
    }

    @Override
    public IRoot getRoot() {
        return this;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public void save() {
    }

    @Override
    public OwningContainer initializeFromStrings(Iterator<String> iterator) {
        return null;
    }

    @Override
    public OwningContainer initializeFromObjects(Object[] iterator) {
        return null;
    }

    @Override
    public boolean hasBeenSaved() {
        return false;
    }

    @Override
    public IOwned<?, ?> getHighestUnsavedOwner() {
        return null;
    }

    @Override
    public void delete() {
    }

    @Override
    public OwningContainer getOwner() {
        return null;
    }
}

