/*
 * Decompiled with CFR 0.152.
 */
package com.ksc.mission.base.relatedobjects;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.ksc.mission.base.fileutils.FileUtil;
import com.ksc.mission.base.interfaces.IOwned;
import com.ksc.mission.base.interfaces.IOwnedCollection;
import com.ksc.mission.base.relatedobjects.OwnedObject;
import com.ksc.mission.base.relatedobjects.Row;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class RowList<OWNER extends IOwned<OWNER, ?>>
implements List<Row<OWNER>>,
IOwnedCollection<Row<OWNER>, OWNER>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected List<String> headers;
    protected final List<Row<OWNER>> rows;
    protected OWNER owner;
    private String id;

    public RowList(OWNER owner) {
        this.owner = owner;
        this.rows = new ArrayList<Row<OWNER>>();
    }

    public RowList(OWNER owner, List<String> headers, List<Row<OWNER>> rows) {
        this.owner = owner;
        this.headers = headers;
        this.rows = rows;
    }

    public RowList<OWNER> initializeFrom(Iterator<String[]> iterator) {
        this.headers = Arrays.asList(iterator.next());
        List rows = new FileUtil("").read(iterator, lineIterator -> ((Row)this.create()).initializeFromStrings((Iterator)lineIterator), lineIterator -> ((String)lineIterator.next()).equalsIgnoreCase("#Properties"));
        this.rows.addAll(rows);
        return this;
    }

    @Override
    public int size() {
        return this.rows.size();
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.headers.indexOf(key) != -1;
    }

    public Set<String> keySet() {
        return new HashSet<String>(this.headers);
    }

    @Override
    public int indexOf(Object key) {
        return this.headers.indexOf(key);
    }

    @Override
    public boolean contains(Object o) {
        return this.rows.contains(o);
    }

    @Override
    public Iterator<Row<OWNER>> iterator() {
        return this.rows.iterator();
    }

    public String[] toArray() {
        return (String[])this.rows.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.rows.toArray(a);
    }

    @Override
    public boolean add(Row<OWNER> e) {
        throw new UnsupportedOperationException("Read Only");
    }

    @Override
    public boolean remove(Object o) {
        return this.rows.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends Row<OWNER>> c) {
        throw new UnsupportedOperationException("Read Only");
    }

    @Override
    public boolean addAll(int index, Collection<? extends Row<OWNER>> c) {
        throw new UnsupportedOperationException("Read Only");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Read Only");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Read Only");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Read Only");
    }

    @Override
    public Row<OWNER> get(int index) {
        return this.rows.get(index);
    }

    @Override
    public Row<OWNER> set(int index, Row<OWNER> element) {
        throw new UnsupportedOperationException("Read Only");
    }

    @Override
    public void add(int index, Row<OWNER> element) {
        throw new UnsupportedOperationException("Read Only");
    }

    @Override
    public Row<OWNER> remove(int index) {
        throw new UnsupportedOperationException("Read Only");
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<Row<OWNER>> listIterator() {
        return this.rows.listIterator();
    }

    @Override
    public ListIterator<Row<OWNER>> listIterator(int index) {
        return this.rows.listIterator(index);
    }

    public Row<OWNER> create() {
        Row row = new Row();
        row.setOwningCollection(this);
        return row;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Row<OWNER> atId(String id) {
        Object newElement = this.basicAtId(id);
        if (newElement == null) {
            newElement = this.create();
            ((OwnedObject)newElement).setId(id);
        }
        return newElement;
    }

    public Row<OWNER> basicAtId(String id) {
        for (Row<OWNER> element : this.rows) {
            if (!element.getId().equals(id)) continue;
            return element;
        }
        return null;
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public void save(Row<OWNER> businessObject) {
        throw new UnsupportedOperationException();
    }

    public void saveAll(List<Row<OWNER>> businessObject) {
        throw new UnsupportedOperationException();
    }

    public void delete(Row<OWNER> obj) {
        throw new UnsupportedOperationException();
    }

    public void deleteAll(List<Row<OWNER>> obj) {
        throw new UnsupportedOperationException();
    }

    @JsonIgnore
    public OWNER getOwner() {
        return this.owner;
    }

    public void setOwner(OWNER owner) {
        this.owner = owner;
    }

    @Override
    public List<Row<OWNER>> subList(int fromIndex, int toIndex) {
        return new RowList<OWNER>(this.owner, this.headers, this.rows.subList(fromIndex, toIndex));
    }

    public void basicSave(Row<OWNER> businessObject) {
    }

    public void basicSaveAll(List<Row<OWNER>> col) {
    }
}

