/*
 * Decompiled with CFR 0.152.
 */
package com.ksc.mission.base.s3;

import com.ksc.mission.base.interfaces.PropertiesReader;
import java.util.Properties;

public class S3Properties {
    public final String type;
    public final String url;
    public final String region;
    public final String user;
    public final String secret;
    public final String bucketName;

    public S3Properties(String type, String url, String region, String user, String secret, String bucketName) {
        this.type = type;
        this.url = url;
        this.region = region;
        this.user = user;
        this.secret = secret;
        this.bucketName = bucketName;
    }

    public static S3Properties defaults() {
        return new S3Properties("AmazonS3", "http://172.17.0.1:48894", "us-west-2", "accessKey1", "verySecretKey1", "mybucket");
    }

    public static S3Properties from(String environmentName) {
        return S3Properties.from(environmentName, "s3", null);
    }

    public static S3Properties from(String environmentName, String propertyFile, String tag) {
        Properties appProps = PropertiesReader.from((String)environmentName, (String)propertyFile);
        String prefix = "s3.";
        if (tag != null && !tag.isEmpty()) {
            prefix = prefix + tag + ".";
        }
        return new S3Properties(appProps.getProperty(prefix + "type"), appProps.getProperty(prefix + "url"), appProps.getProperty(prefix + "region"), appProps.getProperty(prefix + "user"), appProps.getProperty(prefix + "secret"), appProps.getProperty(prefix + "bucketName"));
    }
}

