package com.ksyun.kmr.hadoop.fs.ks3;

public class Constants {
    // ks3 file system schema
    public static final String FS_KS3 = "ks3";

    public static final String ENDPOINT = "fs.ks3.endpoint";
    public static final String DEFAULT_ENDPOINT = "kss.ksyun.com";

    public static final String ACCESS_KEY = "fs.ks3.AccessKey";
    public static final String ACCESS_SECRET = "fs.ks3.AccessSecret";

    public static final String ACCESS_KEY_ENV = "fs_ks3_AccessKey";
    public static final String ACCESS_SECRET_ENV = "fs_ks3_AccessSecret";
    public static final String ENDPOINT_ENV = "fs_ks3_endpoint";

    public static final String CONNECTION_TIMEOUT = "fs.ks3.connection.timeout";
    public static final int DEFAULT_CONNECTION_TIMEOUT = 50000;

    public static final String SOCKET_TIMEOUT = "fs.ks3.socket.timeout";
    public static final int DEFAULT_SOCKET_TIMEOUT = 50000;

    public static final String SOCKET_SEND_BUFFER_SIZE_HINT = "fs.ks3.socket.send.buffer.size.hint";
    public static final int DEFAULT_SOCKET_SEND_BUFFER_SIZE = 8192;

    public static final String SOCKET_RECEIVE_BUFFER_SIZE_HINT = "fs.ks3.socket.receive.buffer.size.hint";
    public static final int DEFAULT_SOCKET_RECEIVE_BUFFER_SIZE = 8192;

    // number of times we should retry errors
    public static final String MAX_ERROR_RETRIES = "fs.ks3.attempts.maximum";
    public static final int DEFAULT_MAX_ERROR_RETRIES = 5;

    // connection ttl
    public static final String CONNECTION_TTL = "fs.ks3.connection.ttl";

    // number of simultaneous connections to ks3
    public static final String MAXIMUM_CONNECTIONS = "fs.ks3.connection.maximum";
    public static final int DEFAULT_MAXIMUM_CONNECTIONS = 70;

    //connect to ks3 through a proxy server?
    public static final String PROXY_HOST = "fs.ks3.proxy.host";
    public static final String PROXY_PORT = "fs.ks3.proxy.port";
    public static final String PROXY_USERNAME = "fs.ks3.proxy.username";
    public static final String PROXY_PASSWORD = "fs.ks3.proxy.password";
    public static final String PROXY_DOMAIN = "fs.ks3.proxy.domain";
    public static final String PROXY_WORKSTATION = "fs.ks3.proxy.workstation";
    public static final String IS_PREEMPTIVE_BASIC_PROXY_AUTH = "fs.ks3.whether.preemptive.basic.proxy.auth";
    public static final boolean DEFAULT_PREEMPTIVE_BASIC_PROXY_AUTH = false;

    // ks3 signer algorithm
    public static final String CLIENT_SIGNER = "fs.ks3.client.signer";
    public static final String DEFAULT_CLIENT_SINGER = "com.ksyun.ks3.signer.DefaultSigner";

    // ks3 client url format
    public static final String CLIENT_URL_FORMAT = "fs.ks3.client.url.format";
    public static final int DEFAULT_CLIENT_URL_FORMAT = 0;

    // ks3 multipart upload
    public static final String MULTIPAET_UPLOADS_BLOCK_SIZE = "fs.ks3.multipart.uploads.block.size";
    public static final int DEFAULT_MULTIPAET_UPLOADS_BLOCK_SIZE = 5 * 1024 * 1024;

    public static final String STORAGE_CLASS = "fs.ks3.storage.class";
    public static final String DEFAULT_STORAGE_CLASS = "Standard";

    public static final String IS_SUPPORT_KS3_STORAGE = "fs.ks3.storage.StandardInfrequentAccess";
    public static final boolean DEFAULT_IS_SUPPORT_KS3_STORAGE = false;

    //整体copy文件大小上限
    public static final String KS3_OVERALL_COPY_TOTAL_LIMIT = "fs.ks3.copy.total.limit.size";
    //整体copy默认最大长度
    public static final long DEFAULT_KS3_OVERALL_COPY_LIMIT_SIZE = 1024L * 1024 * 1024;
    //分块copy块大小
    public static final String KS3_MULTI_PART_COPY_BLOCK_SIZE = "fs.ks3.multicopy.block.size";
    //分块copy默认大小
    public static final int DEFAULT_KS3_PART_COPY_BLOCK_SIZE = 200 * 1024 * 1024;
    // 请求是否启动压缩
    public static final String KS3_REQUEST_COMPRESS_ON = "fs.ks3.request.compress.on";
    public static final boolean DEFAULT_KS3_REQUEST_COMPRESS_ON = true;

    public static final String KS3_REQUEST_ATTEMPTS_MAXIMUM = "fs.ks3.request.attempts.maximum";
    public static final int DEFAULT_KS3_REQUEST_ATTEMPTS_MAXIMUM = 5;
    public static final int DEFAULT_KS3_REQUEST_ATTEMPTS_INTERVAL = DEFAULT_KS3_REQUEST_ATTEMPTS_MAXIMUM - 1;

    public static final String KS3_BLOCK_SIZE = "fs.ks3.block.size";
    public static final int DEFAULT_KS3_BLOCK_SIZE = 128 * 1024 * 1024;

    public static final String KS3_CHECK_SUBDIR_IN_GETFILESTATUS = "fs.ks3.check.subdir.in.getfilestatus";
    public static final boolean DEFAULT_KS3_CHECK_SUBDIR_IN_GETFILESTATUS  = true;

    public static final String KS3_DIRECT_ENABLE = "fs.ks3.direct.enable";
    public static final boolean DEFAULT_KS3_DIRECT_ENABLE = true;

    public static final String PARALLEL_UPLOAD_PART_POOL_SIZE = "parallel.upload.part.pool.size";
    public static final String PARALLEL_UPLOAD_PART_THREAD_SIZE = "parallel.upload.part.thread.size";
    public static final String PARALLEL_UPLOAD_PART_SPEED_LIMIT = "parallel.upload.part.speed.limit";

    public static final String PARALLEL_DELETE_POOL_SIZE = "parallel.delete.pool.size";
    public static final String PARALLEL_DELETE_THREAD_SIZE = "parallel.delete.thread.size";
    public static final String PARALLEL_DELETE_SPEED_LIMIT = "parallel.delete.speed.limit";

    public static final String PARALLEL_COPY_POOL_SIZE = "parallel.copy.pool.size";
    public static final String PARALLEL_COPY_THREAD_SIZE = "parallel.copy.thread.size";
    public static final String PARALLEL_COPY_SPEED_LIMIT = "parallel.copy.speed.limit";

    public static final String PARALLEL_COPY_PART_POOL_SIZE = "parallel.copy.part.pool.size";
    public static final String PARALLEL_COPY_PART_THREAD_SIZE = "parallel.copy.part.thread.size";
    public static final String PARALLEL_COPY_PART_SPEED_LIMIT = "parallel.copy.part.speed.limit";

    public static final String PARALLEL_COMMIT_POOL_SIZE = "parallel.commit.pool.size";
    public static final String PARALLEL_COMMIT_THREAD_SIZE = "parallel.commit.thread.size";
    public static final String PARALLEL_COMMIT_SPEED_LIMIT = "parallel.commit.speed.limit";

    public static final String PARALLEL_UNSER_POOL_SIZE = "parallel.unser.pool.size";
    public static final String PARALLEL_UNSER_THREAD_SIZE = "parallel.unser.thread.size";
    public static final String PARALLEL_UNSER_SPEED_LIMIT = "parallel.unser.speed.limit";

    public static final int DEFAULT_PARALLEL_DELETE_POOL_SIZE = 1024;
    public static final int DEFAULT_PARALLEL_DELETE_THREAD_SIZE = 10;
    public static final int DEFAULT_PARALLEL_DELETE_SPEED_LIMIT = 400;

    public static final int DEFAULT_PARALLEL_COPY_POOL_SIZE = 1024;
    public static final int DEFAULT_PARALLEL_COPY_THREAD_SIZE = 10;
    public static final int DEFAULT_PARALLEL_COPY_SPEED_LIMIT = 400;

    public static final int DEFAULT_PARALLEL_COPY_PART_POOL_SIZE = 1024;
    public static final int DEFAULT_PARALLEL_COPY_PART_THREAD_SIZE = 10;
    public static final int DEFAULT_PARALLEL_COPY_PART_SPEED_LIMIT = 400;

    public static final int DEFAULT_PARALLEL_COMMIT_POOL_SIZE = 1024;
    public static final int DEFAULT_PARALLEL_COMMIT_THREAD_SIZE = 10;
    public static final int DEFAULT_PARALLEL_COMMIT_SPEED_LIMIT = 400;

    public static final int DEFAULT_PARALLEL_UNSER_POOL_SIZE = 4096;
    public static final int DEFAULT_PARALLEL_UNSER_THREAD_SIZE = 10;
    public static final int DEFAULT_PARALLEL_UNSER_SPEED_LIMIT = 400;

    public static final int DEFAULT_PARALLEL_UPLOAD_PART_POOL_SIZE = 16;
    public static final int DEFAULT_PARALLEL_UPLOAD_PART_THREAD_SIZE = 8;
    public static final int DEFAULT_PARALLEL_UPLOAD_PART_SPEED_LIMIT = Integer.MAX_VALUE;

    public static final String GREATER_THAN_THIS_USE_PARALLEL_WHEN_DESTROY = "fs.ks3.greater_than_this_use_parallel_when_destroy";
    public static final int DEFAULT_GREATER_THAN_THIS_USE_PARALLEL_WHEN_DESTROY = 5;

    /**
     * client encrypt key seed
     */
    public static final String KS3_CLIENT_ENCRYPT_KEY_SEED = "fs.ks3.client.encrypt.key.seed";

    /**
     * default client encrypt algorithm, only support "AES" for now
     */
    public static final String DEFAULT_KS3_CLIENT_ENCRYPT_ALGORITHM = "AES";

    /**
     * default client encrypt key size
     */
    public static final int DEFAULT_KS3_CLIENT_ENCRYPT_KEY_SIZE = 128;

    /**
     * the key size must be equal to 128, 192 or 256
     */
    public static final String KS3_CLIENT_ENCRYPT_KEY_SIZE = "fs.ks3.client.encrypt.key.size";

}
