package com.ksyun.kmr.hadoop.fs.ks3;

import com.ksyun.ks3.exception.Ks3ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Random;
import java.util.concurrent.TimeUnit;


public class ExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionHandler.class);

    private static void sleep200MS(boolean notLastRetry){
        if (notLastRetry){
            LOG.info("sleep200MS");
            try {
                TimeUnit.MILLISECONDS.sleep(200);
            } catch(InterruptedException ignored) {
            }
        }
    }

    private static void sleepMoreThan2S(boolean notLastRetry){
        if (notLastRetry) {
            LOG.info("sleepMoreThan2S");
            try {
                TimeUnit.SECONDS.sleep(2 + new Random().nextInt(5));
            } catch (InterruptedException ignored) {
            }
        }
    }

    public static boolean handleKs3ServiceException(int retry, int ks3RequestAttemptsMaximum, Ks3ServiceException e, boolean skip404) {
        boolean notLastRetry = (retry < ks3RequestAttemptsMaximum);

        if (e != null) {
            int status = e.getStatueCode();
            switch(status) {
                case 429:
                    sleepMoreThan2S(notLastRetry);
                    break;
                case 413:
                    throw e;
                case 404:
                    if (skip404){
                        return true;
                    }
                    throw e;
                case 500:
                    sleepMoreThan2S(notLastRetry);
                    break;
                default:
                    sleep200MS(notLastRetry);
            }
        } else {
            sleep200MS(notLastRetry);
        }

        if(retry == ks3RequestAttemptsMaximum){
            LOG.warn(e.getMessage());
            e.printStackTrace();
            throw e;
        }

        return false;
    }

    public static void handleRuntimeException(int retry, int ks3RequestAttemptsMaximum, RuntimeException e) {
        if (retry == ks3RequestAttemptsMaximum) {
            LOG.warn(e.getMessage());
            e.printStackTrace();
            throw e;
        } else {
            sleep200MS(true);
        }
    }
}
