package com.ksyun.kmr.hadoop.fs.ks3;

import com.ksyun.ks3.dto.Authorization;
import com.ksyun.ks3.exception.Ks3ClientException;
import org.apache.hadoop.conf.Configuration;

import java.net.URI;
import java.util.Map;

public class Ks3AuthorizationProvider {
    private String accessKey;
    private String accessKeySecret;

    public Ks3AuthorizationProvider(URI uri, Configuration conf) {
        if (uri.getHost() == null) {
            throw new IllegalArgumentException("Invalid hostname in URI " + uri);
        }

        // First, try to parse key and secret from URI
        String userInfo = uri.getUserInfo();
        if (userInfo != null) {
            int index = userInfo.indexOf(':');
            if (index != -1) {
                accessKey = userInfo.substring(0, index);
                accessKeySecret = userInfo.substring(index + 1);
            } else {
                accessKey = userInfo;
            }
        }

        // Otherwise, try to get key and secret from configuration
        if (accessKey == null) {
            accessKey = conf.get(Constants.ACCESS_KEY);
        }

        if (accessKeySecret == null) {
            accessKeySecret = conf.get(Constants.ACCESS_SECRET);
        }

        // Otherwise, try to get key and secret from env
        Map<String, String> envMap = System.getenv();
        if (accessKey == null) {
            accessKey = envMap.get(Constants.ACCESS_KEY_ENV);
        }
        if (accessKeySecret == null) {
            accessKeySecret = envMap.get(Constants.ACCESS_SECRET_ENV);
        }

        if (accessKey == null || accessKeySecret == null) {
            throw new Ks3ClientException("KMR: " +
                    "Access Key and Access Secret " +
                    "must be specified as the " +
                    "username or password " +
                    "(respectively) of a ks3 " +
                    "URL, or by setting the " +
                    Constants.ACCESS_KEY + " or " +
                    Constants.ACCESS_SECRET +
                    " properties (respectively).");
        }

    }

    public Authorization getCredentials() {
        return new Authorization(accessKey, accessKeySecret);
    }

    @Override
    public String toString() {
        return getClass().getSimpleName();
    }


}
