package com.ksyun.kmr.hadoop.fs.ks3;

import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;

import javax.annotation.concurrent.NotThreadSafe;

public class Ks3BlockBuffer {
    private String key;
    private int blockId;

    DataOutputBuffer outBuffer;
    DataInputBuffer inBuffer = new DataInputBuffer();

    public Ks3BlockBuffer(String key, int blockId, int size) {
        this.key = key;
        this.blockId = blockId;
        outBuffer = new DataOutputBuffer(size);
    }

    public String getKey() {
        return key;
    }

    public int getBlockId() {
        return blockId;
    }

    // 这里使用synchronized主要目的是清除缓存，避免以后扩展此方法产生意外
    // 这里没有使用flush和close因为ByteArrayOutputStream的flush和close没有作用
    public synchronized void refreshInputData(int length) {
        inBuffer.reset(outBuffer.getData(), length);
    }

    /*
    将资源变量主动赋值null，在这里似乎对gc有一定改善
    可以进一步改造DataOutputBuffer，让使用者可以主动释放byte[]
     */
    void clear() {
        inBuffer.reset(null, 0);
        outBuffer = null;
    }
}
