package com.ksyun.kmr.hadoop.fs.ks3;

import com.ksyun.ks3.dto.Ks3ObjectSummary;
import com.ksyun.ks3.dto.ObjectListing;
import com.ksyun.ks3.service.request.ListObjectsRequest;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ListObjectsResult {
    public List<Ks3ObjectSummary> objectSummaries;
    public List<String> commonPrefixes;

    public ListObjectsResult() {
        this.objectSummaries = new ArrayList<>();
        this.commonPrefixes = new ArrayList<>();
    }

    public boolean isNotEmpty(){
        return commonPrefixes.size() > 0 || objectSummaries.size() > 0;
    }

    public List<String> getObjectKeys(){
        return getObjectKeys(false);
    }

    public List<String> getObjectKeys(boolean wantSort){
        Stream<Ks3ObjectSummary> stream = objectSummaries.stream();
        if (wantSort){
            stream = stream.sorted((s1, s2) -> {
                return s1.getKey().compareTo(s2.getKey());
            });
        }

        return stream.map(Ks3ObjectSummary::getKey).collect(Collectors.toList());
    }
}
