package com.ksyun.kmr.hadoop.fs.ks3.committer;

import com.ksyun.kmr.hadoop.fs.ks3.Ks3FileSystem;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.PathOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.PathOutputCommitterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;

public class Ks3CommitterFactory extends PathOutputCommitterFactory {
  public static final Logger LOG = LoggerFactory.getLogger(
    Ks3CommitterFactory.class);

  @Override
  public PathOutputCommitter createOutputCommitter(Path outputPath,
                                                   TaskAttemptContext context) throws IOException {
    FileSystem fs = getDestinationFileSystem(outputPath, context);
    PathOutputCommitter outputCommitter;
    if (fs instanceof Ks3FileSystem) {
      outputCommitter = new CommitInfoFileCommitter(outputPath, context);
    } else {
      throw new RuntimeException("Ks3Filesystem not supported by this committer");
    }
    LOG.info("Using Commmitter {} for {}",
      outputCommitter,
      outputPath);
    return outputCommitter;
  }

  protected FileSystem getDestinationFileSystem(Path outputPath,
                                                JobContext context)
    throws IOException {
    return outputPath != null ?
      FileSystem.get(outputPath.toUri(), context.getConfiguration())
      : null;
  }
}

