package com.ksyun.kmr.hadoop.fs.ks3.committer;

/*
为什么会使用java自带的序列化工具，而不是当前比较流行的工具？
1 protobuf，需要编译，复杂对象嵌套支持不方便，需要整个项目的编译测试步骤都改，并且需要java代码去兼容pb类型
2 kyro，需要序列化的对象结构比较简单，用填充数据的对象实测序列化后的体积没比java序列化的体积小多少
3 json方式的序列化工具经常要安全升级
4 序列化反序列化时间比起网络io消耗的时间不值一提
 */

import com.ksyun.kmr.hadoop.fs.ks3.Utils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import java.util.List;

public class PendingCommit implements java.io.Serializable {
    public static final String EXT = ".pending_commit";

    public String uploadId;
    public String key;
    public List<PartETag> eTags;

    public static class PartETag implements java.io.Serializable {
        public int no;
        public String tag;
    }

    public List<com.ksyun.ks3.dto.PartETag> getKs3PartETags(){
        List<com.ksyun.ks3.dto.PartETag> result = new LinkedList<>();

        for (PartETag eTag : eTags){
            com.ksyun.ks3.dto.PartETag ks3ETag = new com.ksyun.ks3.dto.PartETag();
            ks3ETag.setPartNumber(eTag.no);
            ks3ETag.seteTag(eTag.tag);

            result.add(ks3ETag);
        }

        return result;
    }

    public static PendingCommit build(String key, String uploadId, List<com.ksyun.ks3.dto.PartETag> eTags){
        PendingCommit commit = new PendingCommit();
        commit.key = key;
        commit.uploadId = uploadId;
        commit.eTags = new LinkedList<>();

        for (com.ksyun.ks3.dto.PartETag eTag : eTags){
            PartETag newETag = new PartETag();
            newETag.no = eTag.getPartNumber();
            newETag.tag = eTag.geteTag();
            commit.eTags.add(newETag);
        }

        return commit;
    }

    public static PendingCommit load(FileSystem fs, Path path){
        try {
            FSDataInputStream fsDataInputStream = fs.open(path);
            ObjectInputStream objectInputStream = new ObjectInputStream(fsDataInputStream);

            PendingCommit commit = (PendingCommit)objectInputStream.readObject();
            objectInputStream.close();
            return commit;
        } catch (Exception e){
            Utils.rethrowRuntimeEx(e, "PendingCommit load fail");
        }

        return null;
    }

    public byte[] toBytes(){
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(bos);
            out.writeObject(this);
            out.close();
            return bos.toByteArray();
        } catch (IOException e) {
            e.printStackTrace();
            throw Utils.rethrowRuntimeEx(e, "PendingCommit io error");
        }
    }


}
