package com.ksyun.kmr.hadoop.fs.ks3.committer;

import com.google.common.util.concurrent.RateLimiter;
import com.ksyun.kmr.hadoop.fs.ks3.Ks3FileSystem;
import com.ksyun.kmr.hadoop.fs.ks3.Ks3FileSystemStore;
import com.ksyun.kmr.hadoop.fs.ks3.Utils;
import com.ksyun.ks3.AutoAbortInputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;

/*
在commit task时将信息文件合并到一个文件中，减少commit job时需要处理的文件数量
 */

public class PendingCommitList implements java.io.Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(PendingCommitList.class);
    public static final String EXT = ".pending_commit_list";

    public List<PendingCommit> data = new LinkedList<>();

    public static PendingCommitList load(Ks3FileSystemStore store, String key, RateLimiter rateLimiter){
        try {
            AutoAbortInputStream inputStream = Utils.recordCostTime(LOG, "getInfo", () -> {
                return store.getObject(key, rateLimiter);
            });

            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);

            PendingCommitList commitList = Utils.recordCostTime(LOG, "unser", () -> {
                return objectInputStream.readObject();
            });

            objectInputStream.close();
            return commitList;
        } catch (Exception e){
            Utils.rethrowRuntimeEx(e, "PendingCommitList load fail");
        }

        return null;
    }

    public byte[] toBytes(){
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(bos);
            out.writeObject(this);
            out.close();
            return bos.toByteArray();
        } catch (IOException e) {
            e.printStackTrace();
            throw Utils.rethrowRuntimeEx(e, "PendingCommit io error");
        }
    }
}
