package com.ksyun.kmr.hadoop.fs.ks3.parallel;

import java.util.concurrent.atomic.AtomicReference;

public abstract class Conveyor implements EngineShutter {
    protected AtomicReference<Exception> exceptionAtomicReference;
    protected boolean engineStarted = false;

    public AtomicReference<Exception> getExceptionAtomicReference() {
        return exceptionAtomicReference;
    }

    public Conveyor(AtomicReference<Exception> exceptionAtomicReference){
        this.exceptionAtomicReference = exceptionAtomicReference;
    }

    public abstract void startEnginesWithoutCheckStarted();

    public synchronized void startEngines(){
        if (engineStarted){
            throw new RuntimeException("parallel engine started");
        } else {
            startEnginesWithoutCheckStarted();
            engineStarted = true;
        }
    }
}


