package com.ksyun.kmr.hadoop.fs.ks3.parallel;

import com.ksyun.kmr.hadoop.fs.ks3.Utils;

import java.util.LinkedList;
import java.util.List;

public interface EngineShutter {
    void shutdown();

    static void shutdownAll(EngineShutter... engines){
        List<Exception> es = new LinkedList<>();

        for (EngineShutter engine : engines){
            if (engine == null){
                continue;
            }

            try {
                engine.shutdown();
            } catch (Exception e){
                es.add(e);
            }
        }

        if (es.size() > 0){
            Utils.rethrowRuntimeEx(es.get(0), "from shutdownAll");
        }
    }
}
