package com.ksyun.kmr.hadoop.fs.ks3.parallel;

import com.ksyun.kmr.hadoop.fs.ks3.bean.Event;
import com.lmax.disruptor.WorkHandler;

public class EventHandler implements WorkHandler<Event> {
    private MultiActionEngine engine;
    private Processor processor;

    public static interface Processor {
        public void run(Event data, MultiActionEngine engine);
    }

    public EventHandler(MultiActionEngine engine, Processor processor){
        this.engine = engine;
        this.processor = processor;
    }

    @Override
    public void onEvent(Event event) {
        if (engine.notFail()) {
            try {
                processor.run(event, engine);
                engine.increHandledNum();
            } catch (Exception e) {
                engine.exception.compareAndSet(null, e);
            }
        } else {
            return;
        }
    }
}
