package com.ksyun.kmr.hadoop.fs.ks3.parallel;

import com.ksyun.kmr.hadoop.fs.ks3.bean.Event;
import com.lmax.disruptor.RingBuffer;

import java.util.Map;

public class EventProducer {
    private final RingBuffer<Event> ringBuffer;
    public EventProducer(RingBuffer<Event> ringBuffer) {
        this.ringBuffer = ringBuffer;
    }

    public void onData(Map<String, Object> data) {
        long sequence = ringBuffer.next();
        try {
            Event event = ringBuffer.get(sequence);
            event.setData(data);
        } finally {
            ringBuffer.publish(sequence);
        }
    }
}
