package com.ksyun.kmr.hadoop.fs.ks3.parallel.conveyor;

import com.ksyun.kmr.hadoop.fs.ks3.Ks3FileSystemStore;
import com.ksyun.kmr.hadoop.fs.ks3.ListObjectsResult;
import com.ksyun.kmr.hadoop.fs.ks3.parallel.ListObjectConveyor;
import com.ksyun.ks3.dto.Ks3ObjectSummary;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;

public class CopyDirAction extends CopyAction implements ListObjectConveyor {
    String srcKey;
    String dstKey;

    public CopyDirAction(Ks3FileSystemStore store, String srcKey, String dstKey){
        this(store, srcKey, dstKey, new AtomicReference<>());
    }

    public CopyDirAction(Ks3FileSystemStore store, String srcKey, String dstKey, AtomicReference<Exception> exceptionAtomicReference){
        super(store, exceptionAtomicReference);
        this.srcKey = srcKey;
        this.dstKey = dstKey;
    }

    @Override
    public void run(ListObjectsResult batch) {
        for (Ks3ObjectSummary summary : batch.objectSummaries) {
            String itemSrcKey = summary.getKey();
            String itemDstKey = dstKey + itemSrcKey.substring(srcKey.length());

            boolean sendResult = source().sendData(new HashMap<String, Object>(){
                {
                    put("srcKey", itemSrcKey);
                    put("dstKey", itemDstKey);
                }
            });

            if (!sendResult){
                break;
            }
        }
    }
}
