package com.ksyun.kmr.hadoop.fs.ks3.parallel.conveyor;

import com.google.common.util.concurrent.RateLimiter;
import com.ksyun.kmr.hadoop.fs.ks3.Ks3FileSystemStore;
import com.ksyun.kmr.hadoop.fs.ks3.ListObjectsResult;
import com.ksyun.kmr.hadoop.fs.ks3.bean.Event;
import com.ksyun.kmr.hadoop.fs.ks3.parallel.ActionSource;
import com.ksyun.kmr.hadoop.fs.ks3.parallel.Conveyor;
import com.ksyun.kmr.hadoop.fs.ks3.parallel.EngineShutter;
import com.ksyun.kmr.hadoop.fs.ks3.parallel.ListObjectConveyor;
import com.ksyun.kmr.hadoop.fs.ks3.parallel.MultiActionEngine;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;

public class DestroyAction extends Conveyor implements ListObjectConveyor, ActionSource {
    MultiActionEngine engine;
    Ks3FileSystemStore store;
    int speedLimit;
    boolean skip404 = false;

    public boolean isSkip404() {
        return skip404;
    }

    public void setSkip404(boolean skip404) {
        this.skip404 = skip404;
    }

    public DestroyAction(Ks3FileSystemStore store){
        this(store, (Integer)null);
    }

    public DestroyAction(Ks3FileSystemStore store, Integer speedLimit){
        this(store, speedLimit, new AtomicReference<>());
    }

    public DestroyAction(Ks3FileSystemStore store, AtomicReference<Exception> exceptionAtomicReference){
        this(store, null, exceptionAtomicReference);
    }

    public DestroyAction(Ks3FileSystemStore store, Integer speedLimit, AtomicReference<Exception> exceptionAtomicReference){
        super(exceptionAtomicReference);
        this.store = store;
        if (speedLimit == null){
            this.speedLimit = store.parallel_delete_speed_limit;
        } else {
            this.speedLimit = speedLimit;
        }
    }

    @Override
    public void startEnginesWithoutCheckStarted() {
        engine = new MultiActionEngine("parallel delete", store.parallel_delete_pool_size, store.parallel_delete_thread_size, speedLimit, exceptionAtomicReference, (Event recvData, MultiActionEngine e) -> {
            RateLimiter rateLimiter = e.getRateLimiter();
            String wanted = recvData.getValue("key");
            if (skip404){
                store.deleteObjectSkip404(wanted, rateLimiter);
            } else {
                store.deleteObject(wanted, rateLimiter);
            }
        });
    }

    @Override
    public void shutdown() {
        EngineShutter.shutdownAll(engine);
    }

    @Override
    public void run(ListObjectsResult batch) {
        for (String key : batch.getObjectKeys()){
            if (!sendData(key)){
                break;
            }
        }
    }

    public boolean sendData(String key){
        return engine.sendData(Collections.singletonMap("key", key));
    }

    @Override
    public MultiActionEngine source(){
        return engine;
    }
}
