package com.ksyun.kmr.hadoop.fs.ks3.requestbuilder;

import com.ksyun.kmr.hadoop.fs.ks3.Ks3FileStatus;
import com.ksyun.kmr.hadoop.fs.ks3.Ks3FileSystem;
import com.ksyun.kmr.hadoop.fs.ks3.ListObjectsResult;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;

public class ListLocatedFileStatus {
  public static RemoteIterator<LocatedFileStatus> genIterator(Ks3FileSystem fs, Path f, boolean isFlat, boolean onlyFiles, PathFilter... filters) throws IOException {
    ListFileStatus listFileStatus = new ListFileStatus(fs, f, isFlat);
    if (onlyFiles){
      listFileStatus.withOnlyFiles();
    }

    Ks3FileStatus fileStatus = listFileStatus.fileStatus;

    if (fileStatus.isDirectory()) {
      Iterator<ListObjectsResult> innerIterator = listFileStatus.listDir.genIterator(new AtomicReference<>());

      return new RemoteIterator<LocatedFileStatus>() {
        private boolean firstListing = true;
        private ListIterator<Ks3FileStatus> batchIterator;

        @Override
        public boolean hasNext() throws IOException {
          if (firstListing) {
            requestNextBatch();
            firstListing = false;
          }
          return batchIterator.hasNext() || requestNextBatch();
        }

        @Override
        public LocatedFileStatus next() throws IOException {
          if (hasNext()) {
            Ks3FileStatus status = batchIterator.next();
            return genLocatedFileStatus(fs, status);
          } else {
            throw new NoSuchElementException();
          }
        }

        private boolean requestNextBatch() {
          if (innerIterator.hasNext()){
            ListObjectsResult nextBatch = innerIterator.next();

            batchIterator = listFileStatus.wrapToFileStatus(nextBatch, filters).listIterator();
            return batchIterator.hasNext();
          }

          return false;
        }
      };
    } else {
      return new RemoteIterator<LocatedFileStatus>() {
        private boolean hasNext = true;

        @Override
        public boolean hasNext() throws IOException {
          return fileStatus != null && hasNext &&
            listFileStatus.filterResult(Collections.singletonList(fileStatus), filters).size() > 0;
        }

        @Override
        public LocatedFileStatus next() throws IOException {
          if (hasNext()) {
            hasNext = false;
            return genLocatedFileStatus(fs, fileStatus);
          } else {
            throw new NoSuchElementException();
          }
        }
      };
    }
  }

  public static LocatedFileStatus genLocatedFileStatus(Ks3FileSystem fs, Ks3FileStatus status) throws IOException{
    BlockLocation[] locations = fs.getFileBlockLocations(status,
      0, status.getLen());
    return new LocatedFileStatus(
      status, status.isFile() ? locations : null);
  }
}
