/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.kmr.hadoop.fs.ks3;

import com.ksyun.ks3.exception.Ks3ServiceException;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionHandler.class);

    private static void sleep200MS(boolean notLastRetry) {
        if (notLastRetry) {
            LOG.info("sleep200MS");
            try {
                TimeUnit.MILLISECONDS.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static void sleepMoreThan2S(boolean notLastRetry) {
        if (notLastRetry) {
            LOG.info("sleepMoreThan2S");
            try {
                TimeUnit.SECONDS.sleep(2 + new Random().nextInt(5));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static boolean handleKs3ServiceException(int retry, int ks3RequestAttemptsMaximum, Ks3ServiceException e, boolean skip404) {
        boolean notLastRetry;
        boolean bl = notLastRetry = retry < ks3RequestAttemptsMaximum;
        if (e != null) {
            int status = e.getStatueCode();
            switch (status) {
                case 429: {
                    ExceptionHandler.sleepMoreThan2S(notLastRetry);
                    break;
                }
                case 413: {
                    throw e;
                }
                case 404: {
                    if (skip404) {
                        return true;
                    }
                    throw e;
                }
                case 500: {
                    ExceptionHandler.sleepMoreThan2S(notLastRetry);
                    break;
                }
                default: {
                    ExceptionHandler.sleep200MS(notLastRetry);
                    break;
                }
            }
        } else {
            ExceptionHandler.sleep200MS(notLastRetry);
        }
        if (retry == ks3RequestAttemptsMaximum) {
            LOG.warn(e.getMessage());
            e.printStackTrace();
            throw e;
        }
        return false;
    }

    public static void handleRuntimeException(int retry, int ks3RequestAttemptsMaximum, RuntimeException e) {
        if (retry == ks3RequestAttemptsMaximum) {
            LOG.warn(e.getMessage());
            e.printStackTrace();
            throw e;
        }
        ExceptionHandler.sleep200MS(true);
    }
}

