/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.kmr.hadoop.fs.ks3;

import com.ksyun.ks3.dto.Authorization;
import com.ksyun.ks3.exception.Ks3ClientException;
import java.net.URI;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;

public class Ks3AuthorizationProvider {
    private String accessKey;
    private String accessKeySecret;

    public Ks3AuthorizationProvider(URI uri, Configuration conf) {
        if (uri.getHost() == null) {
            throw new IllegalArgumentException("Invalid hostname in URI " + uri);
        }
        String userInfo = uri.getUserInfo();
        if (userInfo != null) {
            int index = userInfo.indexOf(58);
            if (index != -1) {
                this.accessKey = userInfo.substring(0, index);
                this.accessKeySecret = userInfo.substring(index + 1);
            } else {
                this.accessKey = userInfo;
            }
        }
        if (this.accessKey == null) {
            this.accessKey = conf.get("fs.ks3.AccessKey");
        }
        if (this.accessKeySecret == null) {
            this.accessKeySecret = conf.get("fs.ks3.AccessSecret");
        }
        Map<String, String> envMap = System.getenv();
        if (this.accessKey == null) {
            this.accessKey = envMap.get("fs_ks3_AccessKey");
        }
        if (this.accessKeySecret == null) {
            this.accessKeySecret = envMap.get("fs_ks3_AccessSecret");
        }
        if (this.accessKey == null || this.accessKeySecret == null) {
            throw new Ks3ClientException("KMR: Access Key and Access Secret must be specified as the username or password (respectively) of a ks3 URL, or by setting the fs.ks3.AccessKey or fs.ks3.AccessSecret properties (respectively).");
        }
    }

    public Authorization getCredentials() {
        return new Authorization(this.accessKey, this.accessKeySecret);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

