/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.kmr.hadoop.fs.ks3;

import com.ksyun.kmr.hadoop.fs.ks3.Ks3FileStatus;
import com.ksyun.kmr.hadoop.fs.ks3.Ks3FileSystemStore;
import com.ksyun.kmr.hadoop.fs.ks3.Ks3InputStream;
import com.ksyun.kmr.hadoop.fs.ks3.Ks3OutputStream;
import com.ksyun.kmr.hadoop.fs.ks3.ListObjectsResult;
import com.ksyun.kmr.hadoop.fs.ks3.Utils;
import com.ksyun.kmr.hadoop.fs.ks3.parallel.EngineShutter;
import com.ksyun.kmr.hadoop.fs.ks3.parallel.conveyor.CopyDirAction;
import com.ksyun.kmr.hadoop.fs.ks3.parallel.conveyor.DestroyAction;
import com.ksyun.kmr.hadoop.fs.ks3.requestbuilder.ListDir;
import com.ksyun.kmr.hadoop.fs.ks3.requestbuilder.ListFileStatus;
import com.ksyun.kmr.hadoop.fs.ks3.requestbuilder.ListLocatedFileStatus;
import com.ksyun.ks3.dto.ObjectMetadata;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.crypto.NoSuchPaddingException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadedforhadoopks3.org.apache.commons.lang3.StringUtils;

public class Ks3FileSystem
extends FileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(Ks3FileSystem.class);
    public URI uri;
    public Path workingDir;
    private Ks3FileSystemStore store;
    public long ks3BlockSize;
    public boolean ks3CheckSub;

    public Ks3FileSystemStore getStore() {
        return this.store;
    }

    public void initialize(URI name, Configuration conf) throws IOException {
        super.initialize(name, conf);
        this.uri = URI.create(name.getScheme() + "://" + name.getAuthority());
        this.workingDir = new Path("/user", System.getProperty("user.name")).makeQualified(this.uri, null);
        this.store = new Ks3FileSystemStore();
        this.store.initialize(this.uri, this.workingDir, this.statistics, conf);
        this.ks3BlockSize = conf.getLong("fs.ks3.block.size", 0x8000000L);
        this.ks3CheckSub = conf.getBoolean("fs.ks3.check.subdir.in.getfilestatus", true);
        this.setConf(conf);
    }

    public String getScheme() {
        return "ks3";
    }

    public URI getUri() {
        return this.uri;
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        Ks3FileStatus fileStatus = this.getFileStatus(f);
        if (fileStatus.isDirectory()) {
            throw new FileNotFoundException("Can't open " + f + " because it is a directory");
        }
        Ks3InputStream ks3InputStream = new Ks3InputStream(this.pathToKey(f), fileStatus.getLen(), this.store, this.statistics);
        return new FSDataInputStream((InputStream)((Object)ks3InputStream));
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        OutputStream ks3OutputStream;
        String finalKey;
        Path targetPath = this.toQ(f);
        if (!overwrite && this.exists(targetPath)) {
            throw new FileAlreadyExistsException(targetPath + " already exists");
        }
        Path targetParentPath = targetPath.getParent();
        if (targetParentPath != null) {
            this.mkdirs(targetParentPath);
        }
        String keySeed = this.getConf().get("fs.ks3.client.encrypt.key.seed", null);
        int keySize = this.getConf().getInt("fs.ks3.client.encrypt.key.size", 128);
        if (targetPath.toString().contains("_direct_output_committer_temporary")) {
            finalKey = this.pathToKey(this.getDirectOutputPath(targetPath));
            String infoKey = this.pathToKey(targetPath);
            ks3OutputStream = new Ks3OutputStream(this.store, finalKey, infoKey);
        } else {
            finalKey = this.pathToKey(targetPath);
            ks3OutputStream = new Ks3OutputStream(this.store, finalKey);
        }
        if (null != keySeed) {
            try {
                ks3OutputStream = Utils.getCipherOutputStream(ks3OutputStream, keySeed, keySize);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
                throw new IOException("Cipher exception: Can not get CipherOutputStream.", e);
            }
        }
        return new FSDataOutputStream(ks3OutputStream, this.statistics);
    }

    public FSDataOutputStream createNonRecursive(Path path, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        Path parent = path.getParent();
        if (parent != null && !this.getFileStatus(parent).isDirectory()) {
            throw new FileAlreadyExistsException("Not a directory: " + parent);
        }
        return this.create(path, permission, flags.contains(CreateFlag.OVERWRITE), bufferSize, replication, blockSize, progress);
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new IOException("KS3 File System not supporting Append operation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rename(Path src, Path dst) throws IOException {
        StopWatch sw = new StopWatch().start();
        try {
            boolean bl = this.rename0(src, dst);
            return bl;
        }
        finally {
            long costTime = sw.now(TimeUnit.MICROSECONDS);
            LOG.info("rename cost " + costTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean rename0(Path src, Path dst) throws IOException {
        Ks3FileStatus srcStatus;
        String dstKey;
        String srcKey;
        block18: {
            srcKey = this.pathToKey(src);
            dstKey = this.pathToKey(dst);
            if (srcKey.isEmpty()) return false;
            if (dstKey.isEmpty()) {
                return false;
            }
            try {
                srcStatus = this.getFileStatus(src);
            }
            catch (FileNotFoundException e) {
                LOG.error("rename: src not found {}", (Object)src);
                return false;
            }
            if (srcKey.equals(dstKey)) {
                return srcStatus.isFile();
            }
            Ks3FileStatus dstStatus = null;
            try {
                dstStatus = this.getFileStatus(dst);
                if (dstStatus.isFile()) {
                    return false;
                }
                if (dstStatus.isDirectory() && this.isNotEmptyDir(dstStatus)) {
                    return false;
                }
                if (srcStatus.isFile() && dstStatus.isDirectory()) {
                    return false;
                }
            }
            catch (FileNotFoundException e) {
                Path parent = dst.getParent();
                if (this.pathToKey(parent).isEmpty()) break block18;
                try {
                    Ks3FileStatus dstParentStatus = this.getFileStatus(parent);
                    if (!dstParentStatus.isDirectory()) {
                        return false;
                    }
                }
                catch (FileNotFoundException e2) {
                    return false;
                }
            }
        }
        if (srcStatus.isFile()) {
            this.store.copyObject(srcKey, dstKey);
            this.delete(src, false, srcStatus);
            return true;
        }
        if (!dstKey.endsWith("/")) {
            dstKey = dstKey + "/";
        }
        if (!srcKey.endsWith("/")) {
            srcKey = srcKey + "/";
        }
        if (dstKey.startsWith(srcKey)) {
            return false;
        }
        ListDir listDir = new ListDir(this.store, srcKey, true);
        AtomicReference<Exception> exceptionAtomicReference = new AtomicReference<Exception>();
        DestroyAction destroyAction = new DestroyAction(this.store, exceptionAtomicReference);
        CopyDirAction renameAction = new CopyDirAction(this.store, srcKey, dstKey, exceptionAtomicReference);
        try {
            renameAction.startEngines();
            destroyAction.startEngines();
            renameAction.sink = data -> {
                String copiedSrcKey = (String)data.getLeft();
                destroyAction.sendData(copiedSrcKey);
            };
            listDir.genStream(exceptionAtomicReference).forEach(batch -> renameAction.run((ListObjectsResult)batch));
        }
        catch (Throwable throwable) {
            EngineShutter.shutdownAll(renameAction, destroyAction);
            throw throwable;
        }
        EngineShutter.shutdownAll(renameAction, destroyAction);
        return true;
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        Ks3FileStatus status;
        try {
            status = this.getFileStatus(f);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        return this.delete(f, recursive, status);
    }

    public boolean delete(Path f, boolean recursive, Ks3FileStatus status) throws IOException {
        String key = this.pathToKey(f);
        if (status.isDirectory()) {
            boolean isNotEmptyDirectory = this.isNotEmptyDir(status);
            if (!recursive && isNotEmptyDirectory) {
                throw new IOException("Path is a folder: " + f + " and it is not an empty directory");
            }
            if (!key.endsWith("/")) {
                key = key + "/";
            }
            if (key.equals("/")) {
                return false;
            }
            if (isNotEmptyDirectory) {
                this.store.deleteDir(key, false);
            } else {
                this.store.deleteObject(status.getDirKey());
            }
        } else {
            this.store.deleteObject(key);
        }
        return true;
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        return new ListFileStatus(this, f, false).listStatus(new PathFilter[0]);
    }

    public FileStatus[] listStatusWithFilter(Path f, boolean isFlat, PathFilter ... filters) throws IOException {
        return new ListFileStatus(this, f, isFlat).listStatus(filters);
    }

    public RemoteIterator<LocatedFileStatus> listFiles(Path f, boolean recursive) throws IOException {
        return ListLocatedFileStatus.genIterator(this, f, recursive, true, new PathFilter[0]);
    }

    protected RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f, PathFilter filter) throws IOException {
        return ListLocatedFileStatus.genIterator(this, f, false, false, filter);
    }

    public void setWorkingDirectory(Path new_dir) {
        this.workingDir = new_dir;
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        f = this.toQ(f);
        try {
            Ks3FileStatus fileStatus = this.getFileStatus(f, false);
            if (fileStatus.isDirectory()) {
                return true;
            }
            throw new FileAlreadyExistsException("Path is a file: " + f);
        }
        catch (FileNotFoundException e) {
            this.validatePath(f);
            this.createFakeDirectory(this.pathToKey(f));
            return true;
        }
    }

    public void validatePath(Path f) throws IOException {
        LinkedList<String> toCreateDir = new LinkedList<String>();
        for (Path fPart = f.getParent(); fPart != null && fPart.getParent() != null; fPart = fPart.getParent()) {
            try {
                Ks3FileStatus fileStatus = this.getFileStatus(fPart, false);
                if (fileStatus.isFile()) {
                    throw new FileAlreadyExistsException(String.format("Can't make directory for path '%s' since it is a file.", fPart));
                }
                if (!fileStatus.isDirectory()) continue;
                break;
            }
            catch (FileNotFoundException fnfe) {
                toCreateDir.add(this.pathToKey(fPart));
            }
        }
        for (String key : toCreateDir) {
            this.createFakeDirectory(key);
        }
    }

    public Ks3FileStatus getFileStatus(Path f) throws IOException {
        return this.getFileStatus(f, this.ks3CheckSub);
    }

    public Ks3FileStatus getFileStatus(Path f, boolean checkSub) throws IOException {
        String key = this.pathToKey(f);
        Path qualifiedPath = f.makeQualified(this.uri, this.workingDir);
        if (key.isEmpty()) {
            return new Ks3FileStatus(qualifiedPath, key);
        }
        ObjectMetadata meta = this.store.getMetadata(key);
        if (meta != null) {
            return new Ks3FileStatus(meta.getContentLength(), Ks3FileSystem.dateToLong(meta.getLastModified()), qualifiedPath, this.ks3BlockSize, meta.getETag());
        }
        meta = this.store.getMetadata(key = key + "/");
        if (meta != null) {
            if (this.objectRepresentsDirectory(key, meta.getContentLength())) {
                return new Ks3FileStatus(qualifiedPath, key);
            }
            throw new RuntimeException("filename with \"/\" suffix, please change it to a normal name");
        }
        if (checkSub && this.store.listAllObjects(key, 1).isNotEmpty()) {
            return new Ks3FileStatus(qualifiedPath, key, true);
        }
        throw new FileNotFoundException("No such file or directory: " + f);
    }

    public long getDefaultBlockSize(Path f) {
        return this.ks3BlockSize;
    }

    public boolean objectRepresentsDirectory(String name, long size) {
        return !name.isEmpty() && name.endsWith("/") && size == 0L;
    }

    public static long dateToLong(Date date) {
        if (date == null) {
            return 0L;
        }
        return date.getTime();
    }

    public void createFakeDirectory(String objectName) {
        if ("".equals(objectName)) {
            return;
        }
        if (!objectName.endsWith("/")) {
            objectName = objectName + "/";
        }
        this.store.createEmptyObject(objectName);
    }

    public String pathToKey(Path path) {
        return Ks3FileSystem.pathToKey(path, this.workingDir);
    }

    public static String pathToKey(Path path, Path workingDir) {
        URI u;
        if (!path.isAbsolute()) {
            path = new Path(workingDir, path);
        }
        if ((u = path.toUri()).getScheme() != null && u.getPath().isEmpty()) {
            return "";
        }
        return u.getPath().substring(1);
    }

    public Path keyToPath(String key) {
        return new Path("/" + key);
    }

    public Path getDirectOutputPath(Path qualifiedPath) {
        String pathName = qualifiedPath.toString();
        if (pathName.contains("_direct_output_committer_temporary")) {
            String[] splitedPath1 = pathName.split("_direct_output_committer_temporary");
            String[] splitedPath2 = pathName.split("_direct_output_committer_tasks");
            String[] splitedPath3 = splitedPath2[1].split("/");
            String filename = StringUtils.join((Object[])Arrays.copyOfRange(splitedPath3, 2, splitedPath3.length), "/");
            qualifiedPath = new Path(splitedPath1[0], filename);
        }
        return qualifiedPath;
    }

    public Path toQ(Path f) {
        return f.makeQualified(this.uri, this.workingDir);
    }

    public boolean isNotEmptyDir(Ks3FileStatus ks3FileStatus) throws IOException {
        if (ks3FileStatus.isFile()) {
            throw new RuntimeException("is file, not dir");
        }
        if (ks3FileStatus.isCheckedIsNotEmpty()) {
            return true;
        }
        return this.checkNotEmptyDir(ks3FileStatus.getPath());
    }

    public boolean checkNotEmptyDir(Path path) {
        String dirKey = this.pathToKey(path) + "/";
        ListDir listDir = new ListDir(this.store, dirKey, true, 2, 2);
        List<String> rs = listDir.listAll().getObjectKeys();
        if (rs.contains(dirKey)) {
            return rs.size() > 1;
        }
        return rs.size() > 0;
    }
}

