/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.kmr.hadoop.fs.ks3;

import com.ksyun.kmr.hadoop.FileSystemStoreContext;
import com.ksyun.kmr.hadoop.fs.ks3.Ks3AuthorizationProvider;
import com.ksyun.kmr.hadoop.fs.ks3.Ks3BlockBuffer;
import com.ksyun.kmr.hadoop.fs.ks3.Ks3FileSystem;
import com.ksyun.kmr.hadoop.fs.ks3.ListObjectsResult;
import com.ksyun.kmr.hadoop.fs.ks3.RetryHandler;
import com.ksyun.kmr.hadoop.fs.ks3.Utils;
import com.ksyun.kmr.hadoop.fs.ks3.bean.CopyPartBean;
import com.ksyun.kmr.hadoop.fs.ks3.parallel.MultiActionEngine;
import com.ksyun.kmr.hadoop.fs.ks3.parallel.conveyor.CopyAction;
import com.ksyun.kmr.hadoop.fs.ks3.parallel.conveyor.DestroyAction;
import com.ksyun.kmr.hadoop.fs.ks3.requestbuilder.ListDir;
import com.ksyun.ks3.AutoAbortInputStream;
import com.ksyun.ks3.dto.CopyResult;
import com.ksyun.ks3.dto.GetObjectResult;
import com.ksyun.ks3.dto.HeadObjectResult;
import com.ksyun.ks3.dto.InitiateMultipartUploadResult;
import com.ksyun.ks3.dto.ObjectMetadata;
import com.ksyun.ks3.dto.PartETag;
import com.ksyun.ks3.exception.Ks3ClientException;
import com.ksyun.ks3.exception.Ks3ServiceException;
import com.ksyun.ks3.http.HttpClientConfig;
import com.ksyun.ks3.service.Ks3;
import com.ksyun.ks3.service.Ks3Client;
import com.ksyun.ks3.service.Ks3ClientConfig;
import com.ksyun.ks3.service.common.StorageClass;
import com.ksyun.ks3.service.request.CompleteMultipartUploadRequest;
import com.ksyun.ks3.service.request.CopyObjectRequest;
import com.ksyun.ks3.service.request.CopyPartRequest;
import com.ksyun.ks3.service.request.GetObjectRequest;
import com.ksyun.ks3.service.request.HeadObjectRequest;
import com.ksyun.ks3.service.request.InitiateMultipartUploadRequest;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import com.ksyun.ks3.service.request.PutObjectRequest;
import com.ksyun.ks3.service.request.UploadPartRequest;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadedforhadoopks3.com.google.common.util.concurrent.RateLimiter;
import shadedforhadoopks3.org.apache.commons.lang3.tuple.Pair;

public class Ks3FileSystemStore {
    private static final Logger LOG = LoggerFactory.getLogger(Ks3FileSystemStore.class);
    public Ks3 ks3Client;
    public String bucket;
    private String ks3StorageClass;
    private boolean isSupportKs3Storage;
    private Configuration conf;
    private URI uri;
    private Path workingDir;
    private Ks3ClientConfig ks3config;
    private static SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private long overallCopyMaxLen;
    private int copyBlockSize;
    private FileSystem.Statistics statistics;
    public FileSystemStoreContext context;
    public int parallel_delete_pool_size;
    public int parallel_delete_thread_size;
    public int parallel_delete_speed_limit;
    public int parallel_copy_pool_size;
    public int parallel_copy_thread_size;
    public int parallel_copy_speed_limit;
    public int parallel_copy_part_pool_size;
    public int parallel_copy_part_thread_size;
    public int parallel_copy_part_speed_limit;
    public int parallel_commit_pool_size;
    public int parallel_commit_thread_size;
    public int parallel_commit_speed_limit;
    public int parallel_unser_pool_size;
    public int parallel_unser_thread_size;
    public int parallel_unser_speed_limit;
    public int greater_than_this_use_parallel_when_destroy;
    public int parallel_upload_part_pool_size;
    public int parallel_upload_part_thread_size;
    public int parallel_upload_part_limit;
    public int blockSize;

    public int getBlockSize() {
        return this.blockSize;
    }

    public FileSystem.Statistics getStatistics() {
        return this.statistics;
    }

    public static Pair<String, String> getBucketAndEndpoint(URI uri, String defaultBucket) {
        String host;
        String bucket = host = uri.getHost();
        String endpoint = defaultBucket;
        Pattern pattern = Pattern.compile("\\.(kss|ks3)[\\w-]*\\.ksyun(cs)?\\.com$");
        Matcher matcher = pattern.matcher(host);
        if (matcher.find()) {
            endpoint = matcher.group().substring(1);
            bucket = matcher.replaceAll("");
        }
        return Pair.of(bucket, endpoint);
    }

    public void initialize(URI uri, Path workingDir, FileSystem.Statistics statistics, Configuration conf) {
        this.uri = uri;
        this.workingDir = workingDir;
        this.statistics = statistics;
        String endpointEnv = System.getenv().get("fs_ks3_endpoint");
        String defaultPort = conf.getTrimmed("fs.ks3.endpoint", endpointEnv);
        if (defaultPort == null) {
            defaultPort = "kss.ksyun.com";
        }
        Pair<String, String> result = Ks3FileSystemStore.getBucketAndEndpoint(uri, defaultPort);
        this.bucket = result.getKey();
        String endpoint = result.getValue();
        Ks3ClientConfig ks3config = new Ks3ClientConfig();
        ks3config.setEndpoint(endpoint);
        ks3config.setProtocol(Ks3ClientConfig.PROTOCOL.http);
        ks3config.setSignerClass(conf.getTrimmed("fs.ks3.client.signer", "com.ksyun.ks3.signer.DefaultSigner"));
        ks3config.setPathStyleAccess(this.intValToBoolean(conf.getInt("fs.ks3.client.url.format", 0)));
        HttpClientConfig hconfig = new HttpClientConfig();
        hconfig.setConnectionTimeOut(conf.getInt("fs.ks3.connection.timeout", 50000));
        hconfig.setSocketTimeOut(conf.getInt("fs.ks3.socket.timeout", 50000));
        hconfig.setSocketSendBufferSizeHint(conf.getInt("fs.ks3.socket.send.buffer.size.hint", 8192));
        hconfig.setSocketReceiveBufferSizeHint(conf.getInt("fs.ks3.socket.receive.buffer.size.hint", 8192));
        hconfig.setMaxRetry(conf.getInt("fs.ks3.attempts.maximum", 5));
        hconfig.setConnectionTTL(conf.getInt("fs.ks3.connection.ttl", -1));
        hconfig.setMaxConnections(conf.getInt("fs.ks3.connection.maximum", 70));
        hconfig.setProxyHost(conf.getTrimmed("fs.ks3.proxy.host"));
        hconfig.setProxyPort(conf.getInt("fs.ks3.proxy.port", -1));
        hconfig.setProxyDomain(conf.getTrimmed("fs.ks3.proxy.domain"));
        hconfig.setProxyUserName(conf.getTrimmed("fs.ks3.proxy.username"));
        hconfig.setProxyPassWord(conf.getTrimmed("fs.ks3.proxy.password"));
        hconfig.setProxyWorkStation(conf.getTrimmed("fs.ks3.proxy.workstation"));
        hconfig.setPreemptiveBasicProxyAuth(conf.getBoolean("fs.ks3.whether.preemptive.basic.proxy.auth", false));
        ks3config.setHttpClientConfig(hconfig);
        this.ks3config = ks3config;
        this.ks3StorageClass = conf.getTrimmed("fs.ks3.storage.class", "Standard");
        this.isSupportKs3Storage = conf.getBoolean("fs.ks3.storage.StandardInfrequentAccess", false);
        this.bucket = this.bucket;
        this.conf = conf;
        this.overallCopyMaxLen = this.conf.getLong("fs.ks3.copy.total.limit.size", 0x40000000L);
        this.copyBlockSize = this.conf.getInt("fs.ks3.multicopy.block.size", 0xC800000);
        this.initContext();
        this.renewKs3Client();
        this.initParallelConfig();
    }

    public void initParallelConfig() {
        this.parallel_delete_pool_size = this.conf.getInt("parallel.delete.pool.size", 1024);
        this.parallel_delete_thread_size = this.conf.getInt("parallel.delete.thread.size", 10);
        this.parallel_delete_speed_limit = this.conf.getInt("parallel.delete.speed.limit", 400);
        this.parallel_copy_pool_size = this.conf.getInt("parallel.copy.pool.size", 1024);
        this.parallel_copy_thread_size = this.conf.getInt("parallel.copy.thread.size", 10);
        this.parallel_copy_speed_limit = this.conf.getInt("parallel.copy.speed.limit", 400);
        this.parallel_copy_part_pool_size = this.conf.getInt("parallel.copy.part.pool.size", 1024);
        this.parallel_copy_part_thread_size = this.conf.getInt("parallel.copy.part.thread.size", 10);
        this.parallel_copy_part_speed_limit = this.conf.getInt("parallel.copy.part.speed.limit", 400);
        this.parallel_commit_pool_size = this.conf.getInt("parallel.commit.pool.size", 1024);
        this.parallel_commit_thread_size = this.conf.getInt("parallel.commit.thread.size", 10);
        this.parallel_commit_speed_limit = this.conf.getInt("parallel.commit.speed.limit", 400);
        this.parallel_unser_pool_size = this.conf.getInt("parallel.unser.pool.size", 4096);
        this.parallel_unser_thread_size = this.conf.getInt("parallel.unser.thread.size", 10);
        this.parallel_unser_speed_limit = this.conf.getInt("parallel.unser.speed.limit", 400);
        this.greater_than_this_use_parallel_when_destroy = this.conf.getInt("fs.ks3.greater_than_this_use_parallel_when_destroy", 5);
        this.parallel_upload_part_pool_size = this.conf.getInt("parallel.upload.part.pool.size", 16);
        this.parallel_upload_part_thread_size = this.conf.getInt("parallel.upload.part.thread.size", 8);
        this.parallel_upload_part_limit = this.conf.getInt("parallel.upload.part.speed.limit", Integer.MAX_VALUE);
        this.blockSize = this.conf.getInt("fs.ks3.multipart.uploads.block.size", 0x500000);
    }

    public void initContext() {
        FileSystemStoreContext context = new FileSystemStoreContext();
        context.statistics = this.statistics;
        context.ks3RequestAttemptsMaximum = this.conf.getInt("fs.ks3.request.attempts.maximum", 5);
        this.context = context;
    }

    public int getCopyBlockSize() {
        return this.copyBlockSize;
    }

    public long getOverallCopyMaxLen() {
        return this.overallCopyMaxLen;
    }

    public void renewKs3Client() {
        Ks3AuthorizationProvider provider = new Ks3AuthorizationProvider(this.uri, this.conf);
        this.ks3Client = new Ks3Client(provider.getCredentials()).withKs3config(this.ks3config);
    }

    public ObjectMetadata getMetadata(String objectKey) {
        return this.getMetadata(objectKey, null);
    }

    public ObjectMetadata getMetadata(String objectKey, RateLimiter rateLimiter) {
        HeadObjectResult result = new RetryHandler(true, rateLimiter, 1, this.context).retryProcess(() -> {
            HeadObjectRequest request = new HeadObjectRequest(this.bucket, objectKey);
            return this.ks3Client.headObject(request);
        });
        if (result != null) {
            return result.getObjectMetadata();
        }
        return null;
    }

    public ListObjectsResult listAllSubPaths(String objectKey) {
        return this.listAllSubPaths(objectKey, 0);
    }

    public ListObjectsResult listAllSubPaths(String objectKey, int limit) {
        int pageNum = 1000;
        return this.listAllSubPaths(objectKey, limit, pageNum);
    }

    public ListObjectsResult listAllSubPaths(String objectKey, int limit, int pageNum) {
        ListDir listDir = new ListDir(this, objectKey, false, limit, pageNum);
        return listDir.listAll();
    }

    public ListObjectsResult listAllObjects(String objectKey) {
        return this.listAllObjects(objectKey, 0);
    }

    public ListObjectsResult listAllObjects(String objectKey, int limit) {
        int pageNum = 1000;
        return this.listAllObjects(objectKey, limit, pageNum);
    }

    public ListObjectsResult listAllObjects(String objectKey, int limit, int pageNum) {
        ListDir listDir = new ListDir(this, objectKey, true, limit, pageNum);
        return listDir.listAll();
    }

    public AutoAbortInputStream getObject(String objectKey, long contentLength, long pos) throws EOFException {
        if (pos < 0L) {
            throw new EOFException("Cannot seek to a negative offset " + pos);
        }
        if (contentLength > 0L && pos > contentLength - 1L) {
            throw new EOFException("Attempted to seek or read past the end of the file " + pos);
        }
        GetObjectResult result = new RetryHandler(1, this.context).retryProcess(() -> {
            GetObjectRequest request = new GetObjectRequest(this.bucket, objectKey);
            request.setRange(pos, contentLength - 1L);
            return this.ks3Client.getObject(request);
        });
        return result.getObject().getObjectContent();
    }

    public AutoAbortInputStream getObject(String objectKey) {
        return this.getObject(objectKey, null);
    }

    public AutoAbortInputStream getObject(String objectKey, RateLimiter rateLimiter) {
        GetObjectResult result = new RetryHandler(rateLimiter, 1, this.context).retryProcess(() -> {
            GetObjectRequest request = new GetObjectRequest(this.bucket, objectKey);
            return this.ks3Client.getObject(request);
        });
        return result.getObject().getObjectContent();
    }

    public void putObject(String objectKey, File file) {
        new RetryHandler(3, this.context).retryProcess(() -> {
            PutObjectRequest request = new PutObjectRequest(this.bucket, objectKey, file);
            this.ks3Client.putObject(request);
        });
    }

    public void putObject(String objectKey, byte[] bytes) {
        new RetryHandler(3, this.context).retryProcess(() -> {
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentLength(bytes.length);
            PutObjectRequest request = new PutObjectRequest(this.bucket, objectKey, new ByteArrayInputStream(bytes), meta);
            this.ks3Client.putObject(request);
        });
    }

    public void putObject(Ks3BlockBuffer ks3BlockBuffer, int blockLength) {
        new RetryHandler(3, this.context).retryProcess(() -> {
            ks3BlockBuffer.refreshInputData(blockLength);
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentLength(blockLength);
            PutObjectRequest request = new PutObjectRequest(this.bucket, ks3BlockBuffer.getKey(), (InputStream)ks3BlockBuffer.inBuffer, meta);
            this.ks3Client.putObject(request);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDir(String key, boolean skip404) {
        ListDir listDir = new ListDir(this, key, true);
        DestroyAction destroyAction = new DestroyAction(this);
        destroyAction.setSkip404(skip404);
        try {
            destroyAction.startEngines();
            listDir.genStream(destroyAction.getExceptionAtomicReference()).forEach(batch -> destroyAction.run((ListObjectsResult)batch));
        }
        finally {
            destroyAction.shutdown();
        }
    }

    public void deleteObject(String objectKey) {
        this.deleteObject(objectKey, null);
    }

    public void deleteObject(String objectKey, RateLimiter rateLimiter) {
        new RetryHandler(rateLimiter, 3, this.context).retryProcess(() -> this.ks3Client.deleteObject(this.bucket, objectKey));
    }

    public void deleteObjectSkip404(String objectKey) {
        this.deleteObjectSkip404(objectKey, null);
    }

    public void deleteObjectSkip404(String objectKey, RateLimiter rateLimiter) {
        new RetryHandler(true, rateLimiter, 3, this.context).retryProcess(() -> this.ks3Client.deleteObject(this.bucket, objectKey));
    }

    public void deleteObjects(List<String> objectKeys) {
        if (objectKeys.size() > this.greater_than_this_use_parallel_when_destroy) {
            this.parallelDeleteObjects(objectKeys);
        } else {
            this.serialDeleteObjects(objectKeys);
        }
    }

    public void serialDeleteObjects(List<String> objectKeys) {
        for (String objectKey : objectKeys) {
            this.deleteObject(objectKey);
        }
    }

    public void parallelDeleteObjects(List<String> objectKeys) {
        if (objectKeys.isEmpty()) {
            return;
        }
        this.parallelDeleteObjects((MultiActionEngine engine) -> {
            String key;
            Iterator iterator = objectKeys.iterator();
            while (iterator.hasNext() && engine.sendData(Collections.singletonMap("key", key = (String)iterator.next()))) {
            }
        });
    }

    public void parallelDeleteObjects(EngineSender runnable) {
        this.parallelDeleteObjects(runnable, this.parallel_delete_speed_limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parallelDeleteObjects(EngineSender runnable, int rateLimit) {
        DestroyAction destroyAction = new DestroyAction(this, rateLimit);
        try {
            destroyAction.startEngines();
            runnable.run(destroyAction.source());
        }
        finally {
            destroyAction.shutdown();
        }
    }

    public void copyObject(String srcObjectKey, String dstObjectKey) {
        ObjectMetadata metaData = this.getMetadata(srcObjectKey);
        long contentLength = metaData.getContentLength();
        if (contentLength > this.overallCopyMaxLen) {
            this.copyObjects(Collections.singletonList(Pair.of(srcObjectKey, dstObjectKey)));
        } else {
            this.copyObject(metaData, srcObjectKey, dstObjectKey);
        }
    }

    private StorageClass getStorageClass(ObjectMetadata meta) {
        StorageClass storageClass = null;
        if (this.isSupportKs3Storage) {
            String srcStorageClass = meta.getStorageClass();
            if (srcStorageClass == null) {
                storageClass = StorageClass.Standard;
            } else if (srcStorageClass.equals("STANDARD_IA")) {
                storageClass = StorageClass.StandardInfrequentAccess;
            }
        }
        return storageClass;
    }

    public void copyObject(ObjectMetadata srcMeta, String srcObjectKey, String dstObjectKey) {
        this.copyObject(srcMeta, srcObjectKey, dstObjectKey, null);
    }

    public void copyObject(ObjectMetadata srcMeta, String srcObjectKey, String dstObjectKey, RateLimiter rateLimiter) {
        new RetryHandler(rateLimiter, 3, this.context).retryProcess(() -> {
            CopyObjectRequest request = new CopyObjectRequest(this.bucket, dstObjectKey, this.bucket, srcObjectKey);
            StorageClass storageClass = this.getStorageClass(srcMeta);
            if (storageClass != null) {
                request.setStorageClass(storageClass);
            }
            this.ks3Client.copyObject(request);
        });
    }

    public void copyPart(RateLimiter rateLimiter, CopyPartBean bean) {
        new RetryHandler(rateLimiter, 3, this.context).retryProcess(() -> {
            CopyPartRequest copyRequest = new CopyPartRequest(this.bucket, bean.srcKey, this.bucket, bean.dstKey, bean.partNum, bean.uploadId);
            copyRequest.setBeginRange(bean.beginRange);
            copyRequest.setEndRange(bean.endRange);
            CopyResult copyResult = this.ks3Client.copyPart(copyRequest);
            PartETag eTag = new PartETag();
            eTag.setPartNumber(bean.partNum);
            eTag.seteTag(copyResult.getETag());
            bean.eTags.add(eTag);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyObjects(List<Pair<String, String>> keys) {
        CopyAction copyAction = new CopyAction(this);
        try {
            copyAction.startEngines();
            for (final Pair<String, String> key : keys) {
                boolean sendResult = copyAction.source().sendData((Map<String, Object>)new HashMap<String, Object>(){
                    {
                        this.put("srcKey", key.getLeft());
                        this.put("dstKey", key.getRight());
                    }
                });
                if (sendResult) continue;
                break;
            }
        }
        finally {
            copyAction.shutdown();
        }
    }

    public void createEmptyObject(String objectKey) {
        this.createEmptyObject(objectKey, null);
    }

    public void createEmptyObject(String objectKey, RateLimiter rateLimiter) {
        ObjectMetadata om = new ObjectMetadata();
        om.setContentLength(0L);
        new RetryHandler(rateLimiter, 3, this.context).retryProcess(() -> {
            PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucket, objectKey, new ByteArrayInputStream(new byte[0]), om);
            this.ks3Client.putObject(putObjectRequest);
        });
    }

    public String initMultipartUpload(String objectKey) {
        return this.initMultipartUpload(objectKey, null);
    }

    public String initMultipartUpload(String objectKey, RateLimiter rateLimiter) {
        InitiateMultipartUploadResult result = new RetryHandler(rateLimiter, 3, this.context).retryProcess(() -> {
            InitiateMultipartUploadRequest request = new InitiateMultipartUploadRequest(this.bucket, objectKey);
            if (this.isSupportKs3Storage) {
                if (this.ks3StorageClass.equals("Standard")) {
                    request.setStorageClass(StorageClass.Standard);
                } else if (this.ks3StorageClass.equals("StandardInfrequentAccess")) {
                    request.setStorageClass(StorageClass.StandardInfrequentAccess);
                }
            }
            return this.ks3Client.initiateMultipartUpload(request);
        });
        return result.getUploadId();
    }

    public PartETag uploadPart(Ks3BlockBuffer ks3BlockBuffer, String uploadId, RateLimiter rateLimiter, int blockLength) throws Ks3ClientException, Ks3ServiceException {
        return new RetryHandler(rateLimiter, 3, this.context).retryProcess(() -> {
            ks3BlockBuffer.refreshInputData(blockLength);
            UploadPartRequest uploadPartRequest = new UploadPartRequest(this.bucket, ks3BlockBuffer.getKey(), uploadId, ks3BlockBuffer.getBlockId(), (InputStream)ks3BlockBuffer.inBuffer, blockLength);
            return this.ks3Client.uploadPart(uploadPartRequest);
        });
    }

    public PartETag uploadPart(String objectKey, File file, String uploadId, int partId, long partSize) {
        return new RetryHandler(3, this.context).retryProcess(() -> {
            try {
                FileInputStream content = new FileInputStream(file);
                UploadPartRequest uploadPartRequest = new UploadPartRequest(this.bucket, objectKey, uploadId, partId, content, partSize);
                return this.ks3Client.uploadPart(uploadPartRequest);
            }
            catch (FileNotFoundException e) {
                LOG.warn(e.getMessage());
                throw new RuntimeException(e.getMessage());
            }
        });
    }

    public void completeMultipartUpload(String objectKey, String uploadId, List<PartETag> eTags) {
        this.completeMultipartUpload(objectKey, uploadId, eTags, null);
    }

    public void completeMultipartUpload(String objectKey, String uploadId, List<PartETag> eTags, RateLimiter rateLimiter) {
        Collections.sort(eTags, new Comparator<PartETag>(){

            @Override
            public int compare(PartETag arg1, PartETag arg2) {
                PartETag part1 = arg1;
                PartETag part2 = arg2;
                return part1.getPartNumber() - part2.getPartNumber();
            }
        });
        new RetryHandler(rateLimiter, 3, this.context).retryProcess(() -> {
            CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(this.bucket, objectKey, uploadId, eTags);
            return this.ks3Client.completeMultipartUpload(completeMultipartUploadRequest);
        });
    }

    private boolean intValToBoolean(int val) {
        return val != 0;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void checkIsRequestCompress(Ks3WebServiceRequest request) {
        boolean isON = this.conf.getBoolean("fs.ks3.request.compress.on", true);
        if (!isON) {
            Utils.noUseGzip(request);
        }
    }

    public String pathToKey(Path path) {
        return Ks3FileSystem.pathToKey(path, this.workingDir);
    }

    public static interface EngineSender {
        public void run(MultiActionEngine var1);
    }
}

