/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.kmr.hadoop.fs.ks3;

import com.ksyun.kmr.hadoop.fs.ks3.Ks3FileSystemStore;
import com.ksyun.kmr.hadoop.fs.ks3.Utils;
import com.ksyun.ks3.AutoAbortInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadedforhadoopks3.com.google.common.base.Preconditions;
import shadedforhadoopks3.com.google.common.base.Throwables;
import shadedforhadoopks3.org.apache.http.ConnectionClosedException;

public class Ks3InputStream
extends FSInputStream {
    public static final Logger LOG = LoggerFactory.getLogger(Ks3InputStream.class);
    private static final int MAX_SKIP_SIZE = 0x100000;
    private InputStream in;
    private long streamPosition;
    private long nextReadPosition;
    private Ks3FileSystemStore store;
    private String key;
    private long contentLength;
    private boolean closed;
    private long initTime;

    public Ks3InputStream(String key, long contentLength, Ks3FileSystemStore store, FileSystem.Statistics stats) {
        this.key = key;
        this.contentLength = contentLength;
        this.store = store;
        this.in = null;
        this.closed = false;
        this.initTime = System.currentTimeMillis();
    }

    public void close() {
        this.closed = true;
        this.closeStream();
    }

    public void seek(long pos) {
        Preconditions.checkState(!this.closed, "already closed");
        Preconditions.checkArgument(pos >= 0L, "position is negative: %s", pos);
        this.nextReadPosition = pos;
    }

    public long getPos() {
        return this.nextReadPosition;
    }

    public int read() throws IOException {
        Preconditions.checkState(!this.closed, "already closed");
        int result = -1;
        try {
            this.seekStream();
            result = this.in.read();
            if (result >= 0) {
                ++this.streamPosition;
                ++this.nextReadPosition;
            }
        }
        catch (Exception e) {
            this.closeStream();
            Throwables.propagateIfInstanceOf(e, IOException.class);
            throw Throwables.propagate(e);
        }
        return result;
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        Preconditions.checkState(!this.closed, "already closed");
        try {
            int bytesRead;
            this.seekStream();
            try {
                bytesRead = this.in.read(buffer, offset, length);
            }
            catch (Exception e) {
                if (e instanceof ConnectionClosedException) {
                    LOG.warn("KS3 file {} inputstream closed, reopen and continue read", (Object)this.key);
                    this.closeStream();
                    this.openStream();
                    this.seekStream();
                    bytesRead = this.in.read(buffer, offset, length);
                }
                this.closeStream();
                throw e;
            }
            if (bytesRead != -1) {
                this.streamPosition += (long)bytesRead;
                this.nextReadPosition += (long)bytesRead;
            }
            return bytesRead;
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf(e, IOException.class);
            throw Throwables.propagate(e);
        }
    }

    public boolean seekToNewSource(long targetPos) {
        return false;
    }

    private void seekStream() throws IOException, UnrecoverableS3OperationException {
        long skip;
        if (this.in != null && this.nextReadPosition == this.streamPosition) {
            return;
        }
        if (this.in != null && this.nextReadPosition > this.streamPosition && (skip = this.nextReadPosition - this.streamPosition) <= (long)Math.max(this.in.available(), 0x100000)) {
            try {
                if (this.in.skip(skip) == skip) {
                    this.streamPosition = this.nextReadPosition;
                    return;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.streamPosition = this.nextReadPosition;
        this.closeStream();
        this.openStream();
    }

    private void openStream() throws IOException, UnrecoverableS3OperationException {
        this.in = this.openStream(this.key, this.nextReadPosition);
        this.streamPosition = this.nextReadPosition;
    }

    private InputStream openStream(String key, long start) throws IOException, UnrecoverableS3OperationException {
        try {
            AutoAbortInputStream in = this.store.getObject(key, this.contentLength, start);
            String keySeed = this.store.getConf().get("fs.ks3.client.encrypt.key.seed", null);
            int keySize = this.store.getConf().getInt("fs.ks3.client.encrypt.key.size", 128);
            if (null != keySeed) {
                return Utils.getCipherInputStream(in, keySeed, keySize);
            }
            return in;
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf(e, IOException.class);
            Throwables.propagateIfInstanceOf(e, UnrecoverableS3OperationException.class);
            throw Throwables.propagate(e);
        }
    }

    private void closeStream() {
        if (this.in != null) {
            try {
                if (this.in instanceof AutoAbortInputStream) {
                    ((AutoAbortInputStream)this.in).abort();
                } else {
                    this.in.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.in = null;
        }
    }

    static class UnrecoverableS3OperationException
    extends Exception {
        public UnrecoverableS3OperationException(Path path, Throwable cause) {
            super(String.format("%s (Path: %s)", cause, path), cause);
        }
    }
}

