/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.kmr.hadoop.fs.ks3;

import com.ksyun.kmr.hadoop.fs.ks3.Ks3BlockBuffer;
import com.ksyun.kmr.hadoop.fs.ks3.Ks3FileSystemStore;
import com.ksyun.kmr.hadoop.fs.ks3.committer.PendingCommit;
import com.ksyun.kmr.hadoop.fs.ks3.parallel.MultiActionEngine;
import com.ksyun.ks3.dto.PartETag;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import shadedforhadoopks3.com.google.common.util.concurrent.RateLimiter;

public class Ks3OutputStream
extends OutputStream {
    public static final Log LOG = LogFactory.getLog(Ks3OutputStream.class);
    public final byte[] oneByteAry = new byte[1];
    private Ks3FileSystemStore store;
    private String objectKey;
    private String infoKey;
    private int blockId = 1;
    private int blockAvailable;
    private int blockSize;
    private String uploadId = null;
    private Ks3BlockBuffer blockBuffer;
    private MultiActionEngine engine;
    private volatile boolean closed;
    private List<PartETag> eTags = Collections.synchronizedList(new LinkedList());

    public int getBlockId() {
        return this.blockId;
    }

    public Ks3OutputStream(Ks3FileSystemStore store, String objectKey) {
        this(store, objectKey, null, null);
    }

    public Ks3OutputStream(Ks3FileSystemStore store, String objectKey, String infoKey) {
        this(store, objectKey, infoKey, null);
    }

    public Ks3OutputStream(Ks3FileSystemStore store, String objectKey, String infoKey, Integer blockSize) {
        this.store = store;
        this.objectKey = objectKey;
        this.infoKey = infoKey;
        this.blockSize = blockSize == null ? store.getBlockSize() : blockSize.intValue();
        this.blockBuffer = new Ks3BlockBuffer(this.objectKey, this.blockId, this.blockSize);
        this.blockAvailable = this.blockSize;
        LOG.info((Object)("block_size " + this.blockSize));
    }

    public void startEngine() {
        this.engine = new MultiActionEngine("parallel upload part", this.store.parallel_upload_part_pool_size, this.store.parallel_upload_part_thread_size, this.store.parallel_upload_part_limit, (recvData, e) -> {
            RateLimiter rateLimiter = e.getRateLimiter();
            Ks3BlockBuffer value = (Ks3BlockBuffer)recvData.getValue("block");
            int blockLength = (Integer)recvData.getValue("blockSize");
            PartETag eTag = this.store.uploadPart(value, this.uploadId, rateLimiter, blockLength);
            this.eTags.add(eTag);
            value.clear();
        });
    }

    @Override
    public synchronized void write(int i) throws IOException {
        this.oneByteAry[0] = (byte)i;
        this.write(this.oneByteAry, 0, 1);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed.");
        }
        int left = len;
        int pos = off;
        while (left > 0) {
            this.refreshCurrentPart(false);
            int batchWriteLen = Math.min(left, this.blockAvailable);
            this.blockBuffer.outBuffer.write(b, pos, batchWriteLen);
            this.blockAvailable -= batchWriteLen;
            left -= batchWriteLen;
            pos += batchWriteLen;
        }
    }

    private synchronized void refreshCurrentPart(boolean force) throws IOException {
        if (this.blockAvailable == 0 || force && this.blockAvailable != this.blockSize) {
            if (this.uploadId == null) {
                this.uploadId = this.store.initMultipartUpload(this.objectKey);
                this.startEngine();
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("block", this.blockBuffer);
            data.put("blockSize", this.blockBuffer.outBuffer.getLength());
            this.engine.sendData(data);
            this.blockAvailable = this.blockSize;
            ++this.blockId;
            this.blockBuffer = new Ks3BlockBuffer(this.objectKey, this.blockId, this.blockSize);
        }
    }

    public void shutdownEngine() throws IOException {
        this.refreshCurrentPart(true);
        if (this.engine != null) {
            this.engine.shutdown();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            if (this.infoKey != null) {
                this.shutdownEngine();
                PendingCommit commit = PendingCommit.build(this.objectKey, this.uploadId, this.eTags);
                this.store.putObject(this.infoKey + ".pending_commit", commit.toBytes());
            } else if (this.blockId == 1) {
                this.store.putObject(this.blockBuffer, this.blockBuffer.outBuffer.getLength());
                this.blockBuffer.clear();
            } else {
                this.shutdownEngine();
                this.store.completeMultipartUpload(this.objectKey, this.uploadId, this.eTags);
            }
        }
        catch (Exception e) {
            IOException ioe = new IOException("multipart commit fail");
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            this.closed = true;
        }
    }
}

