/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.kmr.hadoop.fs.ks3;

import com.ksyun.kmr.hadoop.FileSystemStoreContext;
import com.ksyun.kmr.hadoop.fs.ks3.ExceptionHandler;
import com.ksyun.ks3.exception.Ks3ServiceException;
import org.apache.hadoop.fs.FileSystem;
import shadedforhadoopks3.com.google.common.util.concurrent.RateLimiter;

public class RetryHandler {
    public RateLimiter rateLimiter = null;
    public boolean skip404 = false;
    public int kind;
    private FileSystem.Statistics statistics;
    private int ks3RequestAttemptsMaximum;

    public RetryHandler(int kind, FileSystemStoreContext context) {
        this.kind = kind;
        if (context == null || context.statistics == null) {
            throw new RuntimeException("ks3 filesystem not init");
        }
        this.statistics = context.statistics;
        this.ks3RequestAttemptsMaximum = context.ks3RequestAttemptsMaximum;
    }

    public RetryHandler(boolean skip404, int kind, FileSystemStoreContext context) {
        this(kind, context);
        this.skip404 = skip404;
    }

    public RetryHandler(RateLimiter rateLimiter, int kind, FileSystemStoreContext context) {
        this(kind, context);
        this.rateLimiter = rateLimiter;
    }

    public RetryHandler(boolean skip404, RateLimiter rateLimiter, int kind, FileSystemStoreContext context) {
        this(kind, context);
        this.skip404 = skip404;
        this.rateLimiter = rateLimiter;
    }

    private void updateStats() {
        switch (this.kind) {
            case 1: {
                this.statistics.incrementReadOps(1);
                break;
            }
            case 2: {
                this.statistics.incrementLargeReadOps(1);
                break;
            }
            case 3: {
                this.statistics.incrementWriteOps(1);
            }
        }
    }

    public <T> T retryProcess(Processor<T> processor) {
        for (int retry = 1; retry <= this.ks3RequestAttemptsMaximum; ++retry) {
            try {
                if (this.rateLimiter != null) {
                    this.rateLimiter.acquire();
                }
                this.updateStats();
                return processor.run();
            }
            catch (Ks3ServiceException e2) {
                if (!ExceptionHandler.handleKs3ServiceException(retry, this.ks3RequestAttemptsMaximum, e2, this.skip404)) continue;
                break;
            }
            catch (RuntimeException e) {
                ExceptionHandler.handleRuntimeException(retry, this.ks3RequestAttemptsMaximum, e);
            }
        }
        return null;
    }

    public void retryProcess(Runnable runnable) {
        for (int retry = 1; retry <= this.ks3RequestAttemptsMaximum; ++retry) {
            try {
                if (this.rateLimiter != null) {
                    this.rateLimiter.acquire();
                }
                this.updateStats();
                runnable.run();
                break;
            }
            catch (Ks3ServiceException e2) {
                if (!ExceptionHandler.handleKs3ServiceException(retry, this.ks3RequestAttemptsMaximum, e2, this.skip404)) continue;
                break;
            }
            catch (RuntimeException e) {
                ExceptionHandler.handleRuntimeException(retry, this.ks3RequestAttemptsMaximum, e);
            }
        }
    }

    public static interface Processor<T> {
        public T run();
    }
}

