/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.kmr.hadoop.fs.ks3;

import com.ksyun.ks3.http.WebServiceRequestConfig;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.util.StopWatch;
import org.slf4j.Logger;
import shadedforhadoopks3.org.apache.commons.lang3.StringUtils;

public class Utils {
    public static OutputStream getCipherOutputStream(OutputStream out, String keySeed, int keySize) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        Key keySpec = Utils.getKey(keySeed, keySize);
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, keySpec);
        return new CipherOutputStream(out, cipher);
    }

    public static InputStream getCipherInputStream(InputStream in, String keySeed, int keySize) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        Key keySpec = Utils.getKey(keySeed, keySize);
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, keySpec);
        return new CipherInputStream(in, cipher);
    }

    public static Key getKey(String keySeed, int keySize) throws NoSuchAlgorithmException, InvalidKeyException {
        if (StringUtils.isBlank(keySeed)) {
            throw new InvalidKeyException("invalid encrypt key seed");
        }
        KeyGenerator keygen = KeyGenerator.getInstance("AES");
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        random.setSeed(keySeed.getBytes());
        keygen.init(keySize, random);
        SecretKey original_key = keygen.generateKey();
        byte[] raw = original_key.getEncoded();
        SecretKeySpec key = new SecretKeySpec(raw, "AES");
        return key;
    }

    public static void noUseGzip(Ks3WebServiceRequest request) {
        WebServiceRequestConfig config = request.getRequestConfig();
        if (config == null) {
            config = new WebServiceRequestConfig();
        }
        HashMap<String, String> heads = new HashMap<String, String>();
        heads.put("Accept-Encoding", "none");
        config.setExtendHeaders(heads);
        request.setRequestConfig(config);
    }

    public static RuntimeException rethrowRuntimeEx(Exception e, String message) {
        RuntimeException re = new RuntimeException(message);
        re.initCause(e);
        throw re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStackFromException(Exception e) {
        StringWriter sw = null;
        try (PrintWriter pw = null;){
            sw = new StringWriter();
            pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            String string = sw.toString();
            return string;
        }
    }

    public static <T> T recordCostTime(Logger logger, String message, RecordRunnable runnable) throws Exception {
        StopWatch sw = new StopWatch().start();
        Object result = runnable.run();
        long costTime = sw.now(TimeUnit.MICROSECONDS);
        logger.info(message + " cost " + costTime);
        return (T)result;
    }

    public static void recordCostTime(Logger logger, String message, Runnable runnable) {
        StopWatch sw = new StopWatch().start();
        runnable.run();
        long costTime = sw.now(TimeUnit.MICROSECONDS);
        logger.info(message + " cost " + costTime);
    }

    public static interface RecordRunnable {
        public Object run() throws Exception;
    }
}

