/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.kmr.hadoop.fs.ks3.committer;

import com.ksyun.kmr.hadoop.fs.ks3.committer.CommitInfoFileCommitter;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;

public class DirectFileOutputCommitter
extends FileOutputCommitter {
    private static final Log LOG = LogFactory.getLog(DirectFileOutputCommitter.class);
    private boolean directWrite = false;
    private CommitInfoFileCommitter innerCommitter;

    public DirectFileOutputCommitter(Path outputPath, TaskAttemptContext context) throws IOException {
        super(outputPath, context);
        this.init(outputPath, (JobContext)context);
    }

    public DirectFileOutputCommitter(Path outputPath, JobContext context) throws IOException {
        super(outputPath, context);
        this.init(outputPath, context);
    }

    public void init(Path outputPath, JobContext context) throws IOException {
        if (outputPath != null) {
            Configuration conf = context.getConfiguration();
            FileSystem fs = outputPath.getFileSystem(conf);
            this.directWrite = !fs.getClass().getSimpleName().contains("Ks3FileSystem") ? false : conf.getBoolean("fs.ks3.direct.enable", true);
            if (this.directWrite) {
                this.innerCommitter = new CommitInfoFileCommitter(outputPath, context);
            }
            LOG.info((Object)("FileSystem " + fs.getClass() + ", direct write = " + this.directWrite));
        }
    }

    public void setupJob(JobContext context) throws IOException {
        if (this.directWrite) {
            this.innerCommitter.setupJob(context);
        } else {
            super.setupJob(context);
        }
    }

    public void commitJob(JobContext context) throws IOException {
        if (this.directWrite) {
            this.innerCommitter.commitJob(context);
        } else {
            super.commitJob(context);
        }
    }

    public void cleanupJob(JobContext context) throws IOException {
        if (this.directWrite) {
            this.innerCommitter.cleanupJob(context);
        } else {
            super.cleanupJob(context);
        }
    }

    public void abortJob(JobContext context, JobStatus.State state) throws IOException {
        if (this.directWrite) {
            this.innerCommitter.abortJob(context, state);
        } else {
            super.abortJob(context, state);
        }
    }

    public void setupTask(TaskAttemptContext context) throws IOException {
        if (this.directWrite) {
            this.innerCommitter.setupTask(context);
        } else {
            super.setupTask(context);
        }
    }

    public void commitTask(TaskAttemptContext context) throws IOException {
        this.commitTask(context, null);
    }

    public void commitTask(TaskAttemptContext context, Path taskAttemptPath) throws IOException {
        if (this.directWrite) {
            this.innerCommitter.commitTask(context, taskAttemptPath);
        } else {
            super.commitTask(context, taskAttemptPath);
        }
    }

    public void abortTask(TaskAttemptContext context) throws IOException {
        this.abortTask(context, null);
    }

    public void abortTask(TaskAttemptContext context, Path taskAttemptPath) throws IOException {
        if (this.directWrite) {
            this.innerCommitter.abortTask(context, taskAttemptPath);
        } else {
            super.abortTask(context, taskAttemptPath);
        }
    }

    public void recoverTask(TaskAttemptContext context) throws IOException {
        if (this.directWrite) {
            this.innerCommitter.recoverTask(context);
        } else {
            super.recoverTask(context);
        }
    }

    public boolean needsTaskCommit(TaskAttemptContext context) throws IOException {
        return this.needsTaskCommit(context, null);
    }

    public boolean needsTaskCommit(TaskAttemptContext context, Path taskAttemptPath) throws IOException {
        if (this.directWrite) {
            return this.innerCommitter.needsTaskCommit(context, taskAttemptPath);
        }
        return super.needsTaskCommit(context, taskAttemptPath);
    }

    public Path getWorkPath() throws IOException {
        if (this.directWrite) {
            return this.innerCommitter.getWorkPath();
        }
        return super.getWorkPath();
    }

    public boolean isRecoverySupported() {
        if (this.directWrite) {
            return this.innerCommitter.isRecoverySupported();
        }
        return super.isRecoverySupported();
    }

    public boolean isCommitJobRepeatable(JobContext context) throws IOException {
        if (this.directWrite) {
            return this.innerCommitter.isCommitJobRepeatable(context);
        }
        return super.isCommitJobRepeatable(context);
    }
}

