/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.kmr.hadoop.fs.ks3.committer;

import com.ksyun.kmr.hadoop.fs.ks3.Ks3FileSystem;
import com.ksyun.kmr.hadoop.fs.ks3.committer.CommitInfoFileCommitter;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.PathOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.PathOutputCommitterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ks3CommitterFactory
extends PathOutputCommitterFactory {
    public static final Logger LOG = LoggerFactory.getLogger(Ks3CommitterFactory.class);

    public PathOutputCommitter createOutputCommitter(Path outputPath, TaskAttemptContext context) throws IOException {
        FileSystem fs = this.getDestinationFileSystem(outputPath, (JobContext)context);
        if (!(fs instanceof Ks3FileSystem)) {
            throw new RuntimeException("Ks3Filesystem not supported by this committer");
        }
        CommitInfoFileCommitter outputCommitter = new CommitInfoFileCommitter(outputPath, (JobContext)context);
        LOG.info("Using Commmitter {} for {}", (Object)outputCommitter, (Object)outputPath);
        return outputCommitter;
    }

    protected FileSystem getDestinationFileSystem(Path outputPath, JobContext context) throws IOException {
        return outputPath != null ? FileSystem.get((URI)outputPath.toUri(), (Configuration)context.getConfiguration()) : null;
    }
}

