/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.kmr.hadoop.fs.ks3.committer;

import com.ksyun.kmr.hadoop.fs.ks3.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class PendingCommit
implements Serializable {
    public static final String EXT = ".pending_commit";
    public String uploadId;
    public String key;
    public List<PartETag> eTags;

    public List<com.ksyun.ks3.dto.PartETag> getKs3PartETags() {
        LinkedList<com.ksyun.ks3.dto.PartETag> result = new LinkedList<com.ksyun.ks3.dto.PartETag>();
        for (PartETag eTag : this.eTags) {
            com.ksyun.ks3.dto.PartETag ks3ETag = new com.ksyun.ks3.dto.PartETag();
            ks3ETag.setPartNumber(eTag.no);
            ks3ETag.seteTag(eTag.tag);
            result.add(ks3ETag);
        }
        return result;
    }

    public static PendingCommit build(String key, String uploadId, List<com.ksyun.ks3.dto.PartETag> eTags) {
        PendingCommit commit = new PendingCommit();
        commit.key = key;
        commit.uploadId = uploadId;
        commit.eTags = new LinkedList<PartETag>();
        for (com.ksyun.ks3.dto.PartETag eTag : eTags) {
            PartETag newETag = new PartETag();
            newETag.no = eTag.getPartNumber();
            newETag.tag = eTag.geteTag();
            commit.eTags.add(newETag);
        }
        return commit;
    }

    public static PendingCommit load(FileSystem fs, Path path) {
        try {
            FSDataInputStream fsDataInputStream = fs.open(path);
            ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)fsDataInputStream);
            PendingCommit commit = (PendingCommit)objectInputStream.readObject();
            objectInputStream.close();
            return commit;
        }
        catch (Exception e) {
            Utils.rethrowRuntimeEx(e, "PendingCommit load fail");
            return null;
        }
    }

    public byte[] toBytes() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(bos);
            out.writeObject(this);
            out.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw Utils.rethrowRuntimeEx(e, "PendingCommit io error");
        }
    }

    public static class PartETag
    implements Serializable {
        public int no;
        public String tag;
    }
}

