/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.kmr.hadoop.fs.ks3.committer;

import com.ksyun.kmr.hadoop.fs.ks3.Ks3FileSystemStore;
import com.ksyun.kmr.hadoop.fs.ks3.Utils;
import com.ksyun.kmr.hadoop.fs.ks3.committer.PendingCommit;
import com.ksyun.ks3.AutoAbortInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadedforhadoopks3.com.google.common.util.concurrent.RateLimiter;

public class PendingCommitList
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(PendingCommitList.class);
    public static final String EXT = ".pending_commit_list";
    public List<PendingCommit> data = new LinkedList<PendingCommit>();

    public static PendingCommitList load(Ks3FileSystemStore store, String key, RateLimiter rateLimiter) {
        try {
            AutoAbortInputStream inputStream = (AutoAbortInputStream)Utils.recordCostTime(LOG, "getInfo", () -> store.getObject(key, rateLimiter));
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            PendingCommitList commitList = (PendingCommitList)Utils.recordCostTime(LOG, "unser", () -> objectInputStream.readObject());
            objectInputStream.close();
            return commitList;
        }
        catch (Exception e) {
            Utils.rethrowRuntimeEx(e, "PendingCommitList load fail");
            return null;
        }
    }

    public byte[] toBytes() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(bos);
            out.writeObject(this);
            out.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw Utils.rethrowRuntimeEx(e, "PendingCommit io error");
        }
    }
}

