/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.kmr.hadoop.fs.ks3.parallel.conveyor;

import com.ksyun.kmr.hadoop.fs.ks3.Ks3FileSystemStore;
import com.ksyun.kmr.hadoop.fs.ks3.bean.CopyPartBean;
import com.ksyun.kmr.hadoop.fs.ks3.parallel.ActionSource;
import com.ksyun.kmr.hadoop.fs.ks3.parallel.Conveyor;
import com.ksyun.kmr.hadoop.fs.ks3.parallel.EngineShutter;
import com.ksyun.kmr.hadoop.fs.ks3.parallel.MultiActionEngine;
import com.ksyun.ks3.dto.ObjectMetadata;
import com.ksyun.ks3.dto.PartETag;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import shadedforhadoopks3.com.google.common.util.concurrent.RateLimiter;
import shadedforhadoopks3.org.apache.commons.lang3.tuple.Pair;
import shadedforhadoopks3.org.apache.commons.lang3.tuple.Triple;

public class CopyAction
extends Conveyor
implements ActionSource {
    MultiActionEngine mainCopyEngine;
    MultiActionEngine copyPartEngine;
    Ks3FileSystemStore store;
    public Sink sink;

    public CopyAction(Ks3FileSystemStore store) {
        this(store, new AtomicReference<Exception>());
    }

    public CopyAction(Ks3FileSystemStore store, AtomicReference<Exception> exceptionAtomicReference) {
        super(exceptionAtomicReference);
        this.store = store;
    }

    @Override
    public void startEnginesWithoutCheckStarted() {
        this.initCopyEngine();
    }

    @Override
    public void shutdown() {
        EngineShutter.shutdownAll(this.mainCopyEngine, this.copyPartEngine);
    }

    @Override
    public MultiActionEngine source() {
        return this.mainCopyEngine;
    }

    public void initCopyEngine() {
        MultiActionEngine engineForPart = new MultiActionEngine("parallel copy part", this.store.parallel_copy_part_pool_size, this.store.parallel_copy_part_thread_size, this.store.parallel_copy_part_speed_limit, (AtomicReference<Exception>)this.exceptionAtomicReference, (recvData, e) -> {
            RateLimiter rateLimiter = e.getRateLimiter();
            CopyPartBean bean = (CopyPartBean)recvData.getValue("data");
            this.store.copyPart(rateLimiter, bean);
            if (bean.handledNum.incrementAndGet() == bean.totalNum) {
                this.store.completeMultipartUpload(bean.dstKey, bean.uploadId, bean.eTags, rateLimiter);
                if (this.sink != null) {
                    this.sink.callback(Pair.of(bean.srcKey, bean.dstKey));
                }
            }
        });
        MultiActionEngine engine = new MultiActionEngine("parallel copy", this.store.parallel_copy_pool_size, this.store.parallel_copy_thread_size, this.store.parallel_copy_speed_limit, (AtomicReference<Exception>)this.exceptionAtomicReference, (recvData, e) -> {
            RateLimiter rateLimiter = e.getRateLimiter();
            String srcKey = (String)recvData.getValue("srcKey");
            String dstKey = (String)recvData.getValue("dstKey");
            ObjectMetadata metaData = this.store.getMetadata(srcKey, rateLimiter);
            long contentLength = metaData.getContentLength();
            if (contentLength > this.store.getOverallCopyMaxLen()) {
                String uploadId = this.store.initMultipartUpload(dstKey, rateLimiter);
                CopyAction.sendCopyParts(engineForPart, this.store.getCopyBlockSize(), contentLength, srcKey, dstKey, uploadId);
            } else {
                this.store.copyObject(metaData, srcKey, dstKey, rateLimiter);
                if (this.sink != null) {
                    this.sink.callback(Pair.of(srcKey, dstKey));
                }
            }
        });
        this.copyPartEngine = engineForPart;
        this.mainCopyEngine = engine;
    }

    public static void sendCopyParts(MultiActionEngine engine, int blockSize, long contentLength, String srcKey, String dstKey, String uploadId) {
        Triple item;
        CopyPartBean bean;
        List<PartETag> eTags = Collections.synchronizedList(new LinkedList());
        LinkedList<Triple<Integer, Long, Long>> params = new LinkedList<Triple<Integer, Long, Long>>();
        long beginRange = 0L;
        int partNumber = 1;
        AtomicInteger handledNum = new AtomicInteger(0);
        while (beginRange < contentLength) {
            long endRange = Math.min(beginRange + (long)blockSize, contentLength) - 1L;
            params.add(Triple.of(partNumber, beginRange, endRange));
            beginRange = endRange + 1L;
            ++partNumber;
        }
        int totalNum = partNumber - 1;
        Iterator iterator = params.iterator();
        while (iterator.hasNext() && engine.sendData(Collections.singletonMap("data", bean = new CopyPartBean(srcKey, dstKey, uploadId, (Integer)(item = (Triple)iterator.next()).getLeft(), (Long)item.getMiddle(), (Long)item.getRight(), eTags, handledNum, totalNum)))) {
        }
    }

    public static interface Sink {
        public void callback(Pair<String, String> var1);
    }
}

