/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.kmr.hadoop.fs.ks3.parallel.conveyor;

import com.ksyun.kmr.hadoop.fs.ks3.Ks3FileSystemStore;
import com.ksyun.kmr.hadoop.fs.ks3.ListObjectsResult;
import com.ksyun.kmr.hadoop.fs.ks3.parallel.ListObjectConveyor;
import com.ksyun.kmr.hadoop.fs.ks3.parallel.conveyor.CopyAction;
import com.ksyun.ks3.dto.Ks3ObjectSummary;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class CopyDirAction
extends CopyAction
implements ListObjectConveyor {
    String srcKey;
    String dstKey;

    public CopyDirAction(Ks3FileSystemStore store, String srcKey, String dstKey) {
        this(store, srcKey, dstKey, new AtomicReference<Exception>());
    }

    public CopyDirAction(Ks3FileSystemStore store, String srcKey, String dstKey, AtomicReference<Exception> exceptionAtomicReference) {
        super(store, exceptionAtomicReference);
        this.srcKey = srcKey;
        this.dstKey = dstKey;
    }

    @Override
    public void run(ListObjectsResult batch) {
        for (Ks3ObjectSummary summary : batch.objectSummaries) {
            final String itemSrcKey = summary.getKey();
            final String itemDstKey = this.dstKey + itemSrcKey.substring(this.srcKey.length());
            boolean sendResult = this.source().sendData((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("srcKey", itemSrcKey);
                    this.put("dstKey", itemDstKey);
                }
            });
            if (sendResult) continue;
            break;
        }
    }
}

