/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.kmr.hadoop.fs.ks3.parallel.conveyor;

import com.ksyun.kmr.hadoop.fs.ks3.Ks3FileSystemStore;
import com.ksyun.kmr.hadoop.fs.ks3.ListObjectsResult;
import com.ksyun.kmr.hadoop.fs.ks3.parallel.ActionSource;
import com.ksyun.kmr.hadoop.fs.ks3.parallel.Conveyor;
import com.ksyun.kmr.hadoop.fs.ks3.parallel.EngineShutter;
import com.ksyun.kmr.hadoop.fs.ks3.parallel.ListObjectConveyor;
import com.ksyun.kmr.hadoop.fs.ks3.parallel.MultiActionEngine;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import shadedforhadoopks3.com.google.common.util.concurrent.RateLimiter;

public class DestroyAction
extends Conveyor
implements ListObjectConveyor,
ActionSource {
    MultiActionEngine engine;
    Ks3FileSystemStore store;
    int speedLimit;
    boolean skip404 = false;

    public boolean isSkip404() {
        return this.skip404;
    }

    public void setSkip404(boolean skip404) {
        this.skip404 = skip404;
    }

    public DestroyAction(Ks3FileSystemStore store) {
        this(store, (Integer)null);
    }

    public DestroyAction(Ks3FileSystemStore store, Integer speedLimit) {
        this(store, speedLimit, new AtomicReference<Exception>());
    }

    public DestroyAction(Ks3FileSystemStore store, AtomicReference<Exception> exceptionAtomicReference) {
        this(store, null, exceptionAtomicReference);
    }

    public DestroyAction(Ks3FileSystemStore store, Integer speedLimit, AtomicReference<Exception> exceptionAtomicReference) {
        super(exceptionAtomicReference);
        this.store = store;
        this.speedLimit = speedLimit == null ? store.parallel_delete_speed_limit : speedLimit;
    }

    @Override
    public void startEnginesWithoutCheckStarted() {
        this.engine = new MultiActionEngine("parallel delete", this.store.parallel_delete_pool_size, this.store.parallel_delete_thread_size, this.speedLimit, (AtomicReference<Exception>)this.exceptionAtomicReference, (recvData, e) -> {
            RateLimiter rateLimiter = e.getRateLimiter();
            String wanted = (String)recvData.getValue("key");
            if (this.skip404) {
                this.store.deleteObjectSkip404(wanted, rateLimiter);
            } else {
                this.store.deleteObject(wanted, rateLimiter);
            }
        });
    }

    @Override
    public void shutdown() {
        EngineShutter.shutdownAll(this.engine);
    }

    @Override
    public void run(ListObjectsResult batch) {
        for (String key : batch.getObjectKeys()) {
            if (!this.sendData(key)) break;
        }
    }

    public boolean sendData(String key) {
        return this.engine.sendData(Collections.singletonMap("key", key));
    }

    @Override
    public MultiActionEngine source() {
        return this.engine;
    }
}

