/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.kmr.hadoop.fs.ks3.requestbuilder;

import com.ksyun.kmr.hadoop.fs.ks3.Ks3FileSystemStore;
import com.ksyun.kmr.hadoop.fs.ks3.ListObjectsResult;
import com.ksyun.kmr.hadoop.fs.ks3.RetryHandler;
import com.ksyun.ks3.dto.ObjectListing;
import com.ksyun.ks3.service.request.ListObjectsRequest;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.hadoop.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListDir {
    public Ks3FileSystemStore store;
    public int pageNum;
    private boolean isFlat;
    public int limit;
    public String objectKey;
    public int leftNum;
    public ListObjectsRequest request;
    private static final Logger LOG = LoggerFactory.getLogger(ListDir.class);

    public ListDir(Ks3FileSystemStore store, String objectKey, boolean isFlat) {
        this(store, objectKey, isFlat, 0, 1000);
    }

    public ListDir(Ks3FileSystemStore store, String objectKey, boolean isFlat, int limit, int pageNum) {
        this.store = store;
        this.objectKey = objectKey;
        this.isFlat = isFlat;
        this.limit = limit;
        this.pageNum = pageNum;
        this.leftNum = limit == 0 ? Integer.MAX_VALUE : limit;
        this.request = this.genRequest();
    }

    public ListObjectsRequest genRequest() {
        ListObjectsRequest request = new ListObjectsRequest(this.store.bucket);
        request.setPrefix(this.objectKey);
        if (!this.isFlat) {
            request.setDelimiter("/");
        }
        return request;
    }

    public ObjectListing listNextBatchOfResults(ListObjectsRequest request) {
        return new RetryHandler(2, this.store.context).retryProcess(() -> {
            StopWatch sw = new StopWatch().start();
            ObjectListing result = this.store.ks3Client.listObjects(request);
            long costTime = sw.now(TimeUnit.MICROSECONDS);
            LOG.info("listNextBatch cost " + costTime);
            return result;
        });
    }

    public ListObjectsResult listAll() {
        ListObjectsResult result = new ListObjectsResult();
        this.genStream().forEach(item -> {
            result.objectSummaries.addAll(item.objectSummaries);
            result.commonPrefixes.addAll(item.commonPrefixes);
        });
        return result;
    }

    public Stream<ListObjectsResult> genStream() {
        return this.genStream(new AtomicReference<Exception>());
    }

    public Stream<ListObjectsResult> genStream(AtomicReference<Exception> exceptionAtomicReference) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.genIterator(exceptionAtomicReference), 1024), false);
    }

    protected Iterator<ListObjectsResult> genIterator(final AtomicReference<Exception> exceptionAtomicReference) {
        return new Iterator<ListObjectsResult>(){
            StopWatch sw = new StopWatch();

            @Override
            public boolean hasNext() {
                boolean result;
                boolean bl = result = exceptionAtomicReference.get() == null && ListDir.this.leftNum > 0;
                if (!result && this.sw.isRunning()) {
                    long costTime = this.sw.now(TimeUnit.MICROSECONDS);
                    LOG.info("listDirTotal " + ListDir.this.objectKey + " cost " + costTime);
                }
                return result;
            }

            @Override
            public ListObjectsResult next() {
                if (!this.sw.isRunning()) {
                    this.sw.start();
                }
                ListObjectsResult iterResult = new ListObjectsResult();
                int currentPageNum = Math.min(ListDir.this.pageNum, ListDir.this.leftNum);
                ListDir.this.request.setMaxKeys(currentPageNum);
                ObjectListing objects = ListDir.this.listNextBatchOfResults(ListDir.this.request);
                ListDir.this.leftNum -= objects.getObjectSummaries().size() + objects.getCommonPrefixes().size();
                if (objects.isTruncated()) {
                    if (ListDir.this.isFlat) {
                        ListDir.this.request.setMarker(objects.getObjectSummaries().get(objects.getObjectSummaries().size() - 1).getKey());
                    } else {
                        ListDir.this.request.setMarker(objects.getNextMarker());
                    }
                } else {
                    ListDir.this.leftNum = -1;
                }
                iterResult.objectSummaries.addAll(objects.getObjectSummaries());
                iterResult.commonPrefixes.addAll(objects.getCommonPrefixes());
                LOG.info("genStream batch finished");
                return iterResult;
            }
        };
    }
}

