/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.kmr.hadoop.fs.ks3.requestbuilder;

import com.ksyun.kmr.hadoop.fs.ks3.Ks3FileStatus;
import com.ksyun.kmr.hadoop.fs.ks3.Ks3FileSystem;
import com.ksyun.kmr.hadoop.fs.ks3.Ks3FileSystemStore;
import com.ksyun.kmr.hadoop.fs.ks3.ListObjectsResult;
import com.ksyun.kmr.hadoop.fs.ks3.requestbuilder.ListDir;
import com.ksyun.ks3.dto.Ks3ObjectSummary;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;

public class ListFileStatus {
    public Ks3FileSystem ks3FS;
    public Path f;
    public boolean isFlat;
    public Path qualifiedPath;
    public Ks3FileStatus fileStatus;
    public URI pathUri;
    protected ListDir listDir;
    public Ks3FileSystemStore store;
    public boolean relativeSubPathName;
    protected boolean onlyFiles = false;

    public ListFileStatus(Ks3FileSystem ks3FS, Path f, boolean isFlat, Ks3FileStatus fileStatus, boolean relativeSubPathName) {
        this.ks3FS = ks3FS;
        this.store = ks3FS.getStore();
        this.f = f;
        this.isFlat = isFlat;
        this.qualifiedPath = f.makeQualified(ks3FS.uri, ks3FS.workingDir);
        this.fileStatus = fileStatus;
        this.pathUri = this.qualifiedPath.toUri();
        this.relativeSubPathName = relativeSubPathName;
        this.genListDir();
    }

    public ListFileStatus(Ks3FileSystem ks3FS, Path f, boolean isFlat, Ks3FileStatus fileStatus) {
        this(ks3FS, f, isFlat, fileStatus, false);
    }

    public ListFileStatus(Ks3FileSystem ks3FS, Path f, boolean isFlat) throws IOException {
        this(ks3FS, f, isFlat, ks3FS.getFileStatus(f), false);
    }

    public ListFileStatus(Ks3FileSystem ks3FS, Path f, boolean isFlat, boolean relativeSubPathName) throws IOException {
        this(ks3FS, f, isFlat, ks3FS.getFileStatus(f), relativeSubPathName);
    }

    public ListDir getListDir() {
        return this.listDir;
    }

    public ListFileStatus withOnlyFiles() {
        this.onlyFiles = true;
        return this;
    }

    public Stream<ListObjectsResult> genStream(AtomicReference<Exception> exceptionAtomicReference) {
        return this.listDir.genStream(exceptionAtomicReference);
    }

    public static String getDirKey(Ks3FileSystem fs, Path f) {
        String key = fs.pathToKey(f);
        if (!key.isEmpty()) {
            key = key + "/";
        }
        return key;
    }

    public void genListDir() {
        String key = ListFileStatus.getDirKey(this.ks3FS, this.f);
        this.listDir = new ListDir(this.store, key, this.isFlat);
    }

    public Ks3FileStatus[] listStatus(PathFilter ... filters) {
        LinkedList<Ks3FileStatus> statuses = new LinkedList<Ks3FileStatus>();
        if (this.fileStatus.isDirectory()) {
            ListObjectsResult listResult = this.listDir.listAll();
            statuses.addAll(this.wrapToFileStatus(listResult, filters));
        } else {
            statuses.addAll(ListFileStatus.filterResult(Collections.singletonList(this.fileStatus), filters));
        }
        return statuses.toArray(new Ks3FileStatus[0]);
    }

    public List<Ks3FileStatus> wrapToFileStatus(ListObjectsResult listResult) {
        LinkedList<Ks3FileStatus> statuses = new LinkedList<Ks3FileStatus>();
        for (Ks3ObjectSummary summary : listResult.objectSummaries) {
            String itemKey = summary.getKey();
            Path keyPath = this.ks3FS.toQ(this.ks3FS.keyToPath(itemKey));
            String relativePath = this.pathUri.relativize(keyPath.toUri()).getPath();
            if (keyPath.equals((Object)this.qualifiedPath)) continue;
            if (this.relativeSubPathName) {
                keyPath = new Path(relativePath);
            }
            if (this.ks3FS.objectRepresentsDirectory(itemKey, summary.getSize())) {
                if (this.onlyFiles) continue;
                statuses.add(new Ks3FileStatus(keyPath, itemKey));
                continue;
            }
            statuses.add(new Ks3FileStatus(summary.getSize(), Ks3FileSystem.dateToLong(summary.getLastModified()), keyPath, this.ks3FS.ks3BlockSize, summary.getETag()));
        }
        if (!this.onlyFiles) {
            for (String prefix : listResult.commonPrefixes) {
                Path keyPath = this.ks3FS.keyToPath(prefix).makeQualified(this.ks3FS.uri, this.ks3FS.workingDir);
                String relativePath = this.pathUri.relativize(keyPath.toUri()).getPath();
                if (keyPath.equals((Object)this.qualifiedPath)) continue;
                if (this.relativeSubPathName) {
                    keyPath = new Path(relativePath);
                }
                statuses.add(new Ks3FileStatus(keyPath, prefix));
            }
        }
        return statuses;
    }

    public List<Ks3FileStatus> wrapToFileStatus(ListObjectsResult listResult, PathFilter ... filters) {
        return ListFileStatus.filterResult(this.wrapToFileStatus(listResult), filters);
    }

    public static List<Ks3FileStatus> filterResult(List<Ks3FileStatus> statuses, PathFilter ... filters) {
        if (filters.length > 0) {
            LinkedList<Ks3FileStatus> results = new LinkedList<Ks3FileStatus>();
            for (int i = 0; i < statuses.size(); ++i) {
                Ks3FileStatus item = statuses.get(i);
                Path itemPath = item.getPath();
                boolean accept = true;
                for (PathFilter filter : filters) {
                    if (filter.accept(itemPath)) continue;
                    accept = false;
                    break;
                }
                if (!accept) continue;
                results.add(item);
            }
            return results;
        }
        return statuses;
    }
}

