/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.kmr.hadoop.fs.ks3.requestbuilder;

import com.ksyun.kmr.hadoop.fs.ks3.Ks3FileStatus;
import com.ksyun.kmr.hadoop.fs.ks3.Ks3FileSystem;
import com.ksyun.kmr.hadoop.fs.ks3.ListObjectsResult;
import com.ksyun.kmr.hadoop.fs.ks3.requestbuilder.ListFileStatus;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;

public class ListLocatedFileStatus {
    public static RemoteIterator<LocatedFileStatus> genIterator(final Ks3FileSystem fs, Path f, boolean isFlat, boolean onlyFiles, final PathFilter ... filters) throws IOException {
        Ks3FileStatus fileStatus;
        final ListFileStatus listFileStatus = new ListFileStatus(fs, f, isFlat);
        if (onlyFiles) {
            listFileStatus.withOnlyFiles();
        }
        if ((fileStatus = listFileStatus.fileStatus).isDirectory()) {
            final Iterator<ListObjectsResult> innerIterator = listFileStatus.listDir.genIterator(new AtomicReference<Exception>());
            return new RemoteIterator<LocatedFileStatus>(){
                private boolean firstListing = true;
                private ListIterator<Ks3FileStatus> batchIterator;

                public boolean hasNext() throws IOException {
                    if (this.firstListing) {
                        this.requestNextBatch();
                        this.firstListing = false;
                    }
                    return this.batchIterator.hasNext() || this.requestNextBatch();
                }

                public LocatedFileStatus next() throws IOException {
                    if (this.hasNext()) {
                        Ks3FileStatus status = this.batchIterator.next();
                        return ListLocatedFileStatus.genLocatedFileStatus(fs, status);
                    }
                    throw new NoSuchElementException();
                }

                private boolean requestNextBatch() {
                    if (innerIterator.hasNext()) {
                        ListObjectsResult nextBatch = (ListObjectsResult)innerIterator.next();
                        this.batchIterator = listFileStatus.wrapToFileStatus(nextBatch, filters).listIterator();
                        return this.batchIterator.hasNext();
                    }
                    return false;
                }
            };
        }
        return new RemoteIterator<LocatedFileStatus>(){
            private boolean hasNext = true;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean hasNext() throws IOException {
                if (fileStatus == null) return false;
                if (!this.hasNext) return false;
                if (ListFileStatus.filterResult(Collections.singletonList(fileStatus), filters).size() <= 0) return false;
                return true;
            }

            public LocatedFileStatus next() throws IOException {
                if (this.hasNext()) {
                    this.hasNext = false;
                    return ListLocatedFileStatus.genLocatedFileStatus(fs, fileStatus);
                }
                throw new NoSuchElementException();
            }
        };
    }

    public static LocatedFileStatus genLocatedFileStatus(Ks3FileSystem fs, Ks3FileStatus status) throws IOException {
        BlockLocation[] locations = fs.getFileBlockLocations(status, 0L, status.getLen());
        return new LocatedFileStatus((FileStatus)status, (BlockLocation[])(status.isFile() ? locations : null));
    }
}

