/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.exception;

import com.ksyun.ks3.exception.Ks3ClientException;
import com.ksyun.ks3.utils.StringUtils;
import com.ksyun.ks3.utils.XmlReader;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import shadedforhadoopks3.org.apache.http.HttpResponse;
import shadedforhadoopks3.org.apache.http.client.methods.HttpRequestBase;

public class Ks3ServiceException
extends Ks3ClientException {
    private static final long serialVersionUID = 5225806336951827450L;
    private Log log = LogFactory.getLog(Ks3ServiceException.class);
    private String errorCode;
    private int statueCode;
    private String expectedStatueCode;
    private String errorMessage;
    private String resource;
    private String requestId;

    public Ks3ServiceException() {
        super("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ks3ServiceException(HttpRequestBase request, HttpResponse response, String expected) {
        super("");
        this.expectedStatueCode = expected;
        this.statueCode = response.getStatusLine().getStatusCode();
        try {
            InputStream in = response.getEntity().getContent();
            String xml = StringUtils.inputStream2String(in);
            this.log.debug((Object)xml);
            Document document = new XmlReader(xml).getDocument();
            try {
                this.errorMessage = document.getElementsByTagName("Message").item(0).getTextContent();
            }
            catch (Exception e) {
                this.errorMessage = "unknow";
            }
            try {
                this.errorCode = document.getElementsByTagName("Code").item(0).getTextContent();
            }
            catch (Exception e) {
                this.errorCode = "unknow";
            }
            try {
                this.resource = document.getElementsByTagName("Resource").item(0).getTextContent();
            }
            catch (Exception e) {
                this.resource = "unknow";
            }
            try {
                this.requestId = document.getElementsByTagName("RequestId").item(0).getTextContent();
            }
            catch (Exception e) {
                this.requestId = "unknow";
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (request != null) {
                request.abort();
            }
            try {
                if (response.getEntity().getContent() != null) {
                    response.getEntity().getContent().close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public Ks3ServiceException(HttpResponse response, String expected) {
        this(null, response, expected);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + ":" + "[RequestId:" + this.requestId + ",Resource:" + this.resource + ",Statue code:" + this.statueCode + ",Expected statue code:" + this.expectedStatueCode + ",Error code:" + this.errorCode + ",Error message:" + this.errorMessage + "]";
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public int getStatueCode() {
        return this.statueCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getResource() {
        return this.resource;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getExpectedStatueCode() {
        return this.expectedStatueCode;
    }

    public void setExpectedStatueCode(String expectedStatueCode) {
        this.expectedStatueCode = expectedStatueCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public void setStatueCode(int statueCode) {
        this.statueCode = statueCode;
    }

    public void setErrorMessage(String message) {
        this.errorMessage = message;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public <X extends Ks3ServiceException> RuntimeException convert(String reqid) {
        String error;
        if (!StringUtils.isBlank(reqid)) {
            this.setRequestId(reqid);
        }
        if (StringUtils.isBlank(this.getErrorCode()) || "unknow".equals(this.getErrorCode())) {
            if (this.statueCode == 400) {
                this.setErrorCode("InvalidArgument");
            } else if (this.statueCode == 403) {
                this.setErrorCode("AccessDenied");
            } else if (this.statueCode == 404) {
                this.setErrorCode("NotFound");
            } else if (this.statueCode == 405) {
                this.setErrorCode("MethodNotAllowed");
            }
        }
        if (!StringUtils.isBlank(error = this.getErrorCode())) {
            error = error.substring(0, 1).toUpperCase() + error.substring(1);
        }
        String classString = "com.ksyun.ks3.exception.serviceside." + error + "Exception";
        try {
            Ks3ServiceException e = (Ks3ServiceException)Class.forName(classString).newInstance();
            e.setErrorMessage(this.getErrorMessage());
            e.setErrorCode(this.getErrorCode());
            e.setExpectedStatueCode(this.getExpectedStatueCode());
            e.setRequestId(this.getRequestId());
            e.setResource(this.getResource());
            e.setStatueCode(this.getStatueCode());
            e.setStackTrace(this.getStackTrace());
            return e;
        }
        catch (Throwable e) {
            return this;
        }
    }
}

