/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.http;

import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.service.Ks3ClientConfig;
import com.ksyun.ks3.utils.HttpUtils;
import com.ksyun.ks3.utils.StringUtils;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Request {
    private HttpMethod method;
    private Date expires;
    private String endpoint;
    private String bucket;
    private String key;
    private Map<String, String> queryParams = new HashMap<String, String>();
    private Map<String, String> headers = new HashMap<String, String>();
    private InputStream content;
    private String region;

    public String toUrl(Ks3ClientConfig ks3config) {
        String url = "";
        String bucket = this.getBucket();
        String key = this.getKey();
        String endpoint = this.getEndpoint();
        String encodedParams = HttpUtils.encodeParams(this.getQueryParams());
        key = HttpUtils.urlEncode(key, true);
        boolean pathStyle = ks3config.isPathStyleAccess();
        boolean domainMode = ks3config.isDomainMode();
        Ks3ClientConfig.PROTOCOL spePro = ks3config.getProtocol();
        if (spePro == null) {
            spePro = Ks3ClientConfig.PROTOCOL.http;
        }
        url = !domainMode ? (!pathStyle ? new StringBuffer().append(StringUtils.isBlank(bucket) ? "" : bucket + ".").append(endpoint).append(StringUtils.isBlank(key) ? "" : "/" + key).toString() : new StringBuffer().append(endpoint).append(StringUtils.isBlank(bucket) ? "" : "/" + bucket).append(StringUtils.isBlank(key) ? "" : "/" + key).toString()) : new StringBuffer().append(endpoint).append(StringUtils.isBlank(key) ? "" : "/" + key).toString();
        url = url.replace("//", "/%2F");
        url = spePro.toString() + "://" + url;
        if (!StringUtils.isBlank(encodedParams)) {
            url = url + "?" + encodedParams;
        }
        return url;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    public void setQueryParams(Map<String, String> queryParams) {
        this.queryParams = queryParams;
    }

    public void addQueryParam(String key, String value) {
        this.queryParams.put(key, value);
    }

    public void addQueryParamIfNotNull(String key, String value) {
        if (!StringUtils.isBlank(value)) {
            this.addQueryParam(key, value);
        }
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void addHeader(HttpHeaders key, String value) {
        this.addHeader(key.toString(), value);
    }

    public void addHeaderIfNotContains(String key, String value) {
        if (!this.headers.containsKey(key)) {
            this.addHeader(key, value);
        }
    }

    public InputStream getContent() {
        return this.content;
    }

    public void setContent(InputStream content) {
        this.content = content;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public Date getExpires() {
        return this.expires;
    }

    public void setExpires(Date expires) {
        this.expires = expires;
    }

    public boolean isPresign() {
        return this.expires != null;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }
}

