/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.http;

import com.ksyun.ks3.MD5DigestCalculatingInputStream;
import com.ksyun.ks3.RepeatableFileInputStream;
import com.ksyun.ks3.RepeatableInputStream;
import com.ksyun.ks3.dto.Authorization;
import com.ksyun.ks3.exception.Ks3ClientException;
import com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator;
import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.RepeatableInputStreamRequestEntity;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.service.Ks3ClientConfig;
import com.ksyun.ks3.service.request.GetObjectRequest;
import com.ksyun.ks3.service.request.HeadObjectRequest;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import com.ksyun.ks3.service.request.SSECustomerKeyRequest;
import com.ksyun.ks3.signer.Signer;
import com.ksyun.ks3.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.regex.Pattern;
import shadedforhadoopks3.org.apache.http.HttpEntity;
import shadedforhadoopks3.org.apache.http.client.methods.HttpDelete;
import shadedforhadoopks3.org.apache.http.client.methods.HttpGet;
import shadedforhadoopks3.org.apache.http.client.methods.HttpHead;
import shadedforhadoopks3.org.apache.http.client.methods.HttpPost;
import shadedforhadoopks3.org.apache.http.client.methods.HttpPut;
import shadedforhadoopks3.org.apache.http.client.methods.HttpRequestBase;
import shadedforhadoopks3.org.apache.http.entity.BufferedHttpEntity;

public class RequestBuilder {
    public static void buildRequest(Ks3WebServiceRequest ks3Request, Request request, Authorization auth, Ks3ClientConfig ks3config) {
        String userAuth;
        String endpoint0;
        Map<String, String> headers;
        ks3Request.validateParams();
        if (ks3Request.getRequestConfig() != null && (headers = ks3Request.getRequestConfig().getExtendHeaders()) != null) {
            request.getHeaders().putAll(headers);
        }
        ks3Request.buildRequest(request);
        request.addHeaderIfNotContains(HttpHeaders.UserAgent.toString(), ks3Request.getRequestConfig().getUserAgent());
        if (ks3config != null && !ks3config.isUseGzip() && (ks3Request instanceof GetObjectRequest || ks3Request instanceof HeadObjectRequest)) {
            request.addHeader("Accept-Encoding", "none");
        }
        if (!request.isPresign()) {
            request.addHeaderIfNotContains(HttpHeaders.ContentType.toString(), "application/xml");
            if (request.getHeaders().get(HttpHeaders.ContentType.toString()) == null) {
                request.getHeaders().remove(HttpHeaders.ContentType.toString());
            }
        }
        if (StringUtils.isBlank(endpoint0 = ks3Request.getRequestConfig().getEndpoint())) {
            endpoint0 = ks3config.getEndpoint();
        }
        if (StringUtils.isBlank(endpoint0)) {
            throw new Ks3ClientException("endpoint is blank");
        }
        request.setEndpoint(endpoint0);
        try {
            if (auth != null) {
                String signerString = ks3config.getSignerClass();
                Signer signer = (Signer)Class.forName(signerString).newInstance();
                if (ks3config.getVersion() == Ks3ClientConfig.SignerVersion.V2) {
                    signer.sign(auth, request);
                } else {
                    request.setRegion(ks3config.getRegion().toString());
                    signer.signV4(auth, request, ks3config);
                }
            } else if (!ks3config.isAllowAnonymous()) {
                throw new Ks3ClientException("sdk is not allowed to send anonymous request");
            }
        }
        catch (Exception e) {
            throw new Ks3ClientException(e);
        }
        if (!request.isPresign() && !StringUtils.isBlank(userAuth = ks3Request.getRequestConfig().getExtendHeaders().get(HttpHeaders.Authorization.toString()))) {
            request.addHeader(HttpHeaders.Authorization, userAuth);
        }
        for (String headerName : request.getHeaders().keySet()) {
            if (Pattern.matches("^[\\-0-9A-Z_a-z]+$", headerName)) continue;
            throw ClientIllegalArgumentExceptionGenerator.notCorrect("header", headerName, "^[\\-0-9A-Z_a-z]+$");
        }
    }

    public static HttpRequestBase buildHttpRequest(Ks3WebServiceRequest ks3Request, Request request, Authorization auth, Ks3ClientConfig ks3config) {
        HttpEntity entity;
        String length;
        HttpMethod method = request.getMethod();
        HttpRequestBase httpRequest = null;
        if (request.getContent() != null && !(request.getContent() instanceof RepeatableInputStream) && !(request.getContent() instanceof RepeatableFileInputStream)) {
            request.setContent(new RepeatableInputStream(request.getContent(), 131072));
        }
        if (!RequestBuilder.skipMD5Check(ks3Request, request) && !(request.getContent() instanceof MD5DigestCalculatingInputStream)) {
            request.setContent(new MD5DigestCalculatingInputStream(request.getContent()));
        }
        String url = request.toUrl(ks3config);
        InputStream requestBody = request.getContent();
        if (method == HttpMethod.POST) {
            HttpPost postMethod = new HttpPost(url);
            if (requestBody != null) {
                length = request.getHeaders().get(HttpHeaders.ContentLength.toString());
                entity = new RepeatableInputStreamRequestEntity(requestBody, length);
                if (!StringUtils.checkLong(length) || Long.parseLong(length) < 0L) {
                    try {
                        entity = new BufferedHttpEntity(entity);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw new Ks3ClientException("\u521d\u59cb\u5316Http Request\u51fa\u9519(" + e + ")", e);
                    }
                }
                postMethod.setEntity(entity);
            }
            httpRequest = postMethod;
        } else if (method == HttpMethod.GET) {
            HttpGet getMethod = new HttpGet(url);
            httpRequest = getMethod;
        } else if (method == HttpMethod.PUT) {
            HttpPut putMethod = new HttpPut(url);
            httpRequest = putMethod;
            putMethod.getParams().setParameter("http.protocol.expect-continue", true);
            if (requestBody != null) {
                length = request.getHeaders().get(HttpHeaders.ContentLength.toString());
                entity = null;
                if (length == null || length.trim().equals("0")) {
                    try {
                        entity = new RepeatableInputStreamRequestEntity(requestBody, "-1");
                        entity = new BufferedHttpEntity(entity);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw new Ks3ClientException("\u521d\u59cb\u5316Http Request\u51fa\u9519(" + e + ")", e);
                    }
                } else {
                    entity = new RepeatableInputStreamRequestEntity(requestBody, length);
                }
                putMethod.setEntity(entity);
            }
        } else if (method == HttpMethod.DELETE) {
            HttpDelete deleteMethod = new HttpDelete(url);
            httpRequest = deleteMethod;
        } else if (method == HttpMethod.HEAD) {
            HttpHead headMethod = new HttpHead(url);
            httpRequest = headMethod;
        } else {
            throw new Ks3ClientException("Unknow http method : " + (Object)((Object)method));
        }
        for (Map.Entry<String, String> aHeader : request.getHeaders().entrySet()) {
            if (httpRequest.containsHeader(aHeader.getKey())) continue;
            httpRequest.setHeader(aHeader.getKey(), aHeader.getValue());
        }
        httpRequest.removeHeaders(HttpHeaders.ContentLength.toString());
        return httpRequest;
    }

    private static boolean skipMD5Check(Ks3WebServiceRequest wsReq, Request req) {
        if (wsReq instanceof SSECustomerKeyRequest) {
            if (((SSECustomerKeyRequest)((Object)wsReq)).getSseCustomerKey() != null) {
                return true;
            }
            if (req.getContent() == null) {
                return true;
            }
            return !StringUtils.isBlank(req.getHeaders().get(HttpHeaders.ContentMD5.toString()));
        }
        return true;
    }
}

